package com.bcxin.backend.domain.models;


/**
 * <b> 通用返回结果 </b>
 * @author ZXF
 * @create 2022/09/22 0022 15:28
 * @version
 * @注意事项 </b>
 */
public class Result<T> {

	private String retType = "0";// 状态码
	private T data;// 返回数据对象
	private String msg = SUCCESS_MSG;// 返回信息
	/**
	 * 成功
	 */
	public static final String SUCCESS = "0";

	/**
	 * 服务端内部错误
	 */
	public static final String ERROR = "-1";

	/**
	 * 成功消息
	 */
	public static final String SUCCESS_MSG = "操作成功！";
	/**
	 * 失败消息
	 */
	public static final String ERROR_MSG = "操作失败:";

	public Result() {
		super();
	}

	/**
	 * @param retType    结果状态码
	 * @param message 响应结果描述
	 * @param data    成功时返回的数据结果
	 */
	private Result(String retType, String message, T data) {
		super();
		this.retType = retType;
		this.msg = message;
		this.data = data;
	}

	/**
	 * 成功信息返回
	 *
	 * @param successMsg
	 * @param data
	 * @return
	 */
	public Result success(String successMsg, T data) {
		return new Result( Result.SUCCESS,
				(successMsg == null || successMsg.equals("")) ? Result.SUCCESS_MSG : successMsg, data);
	}

	/**
	 * 错误信息返回
	 *
	 * @param errorMsg
	 * @param data
	 * @return
	 */
	public Result fail(String errorMsg, T data) {
		return new Result( Result.ERROR,
				(errorMsg == null || errorMsg.equals("")) ? Result.ERROR_MSG : errorMsg, data);
	}

	/**
	 * 成功信息返回
	 *
	 * @param successMsg
	 * @return
	 */
	public static Result success(String successMsg) {
		return new Result( Result.SUCCESS,
				(successMsg == null || successMsg.equals("")) ? Result.SUCCESS_MSG : successMsg, null);
	}

	/**
	 * 错误信息返回
	 *
	 * @param errorMsg
	 * @return
	 */
	public static Result fail(String errorMsg) {
		return new Result( Result.ERROR,
				(errorMsg == null || errorMsg.equals("")) ? Result.ERROR_MSG : errorMsg, null);
	}

	public String getRetType() {
		return retType;
	}

	public void setRetType(String retType) {
		this.retType = retType;
	}

	public String getMsg() {
		return msg;
	}

	public void setMsg(String msg) {
		this.msg = msg;
	}

	public T getData() {
		return data;
	}

	public void setData(T data) {
		this.data = data;
	}

}
