package com.bcxin.backend.domain.enums;

public enum ResetDocumentType {
    BASLXK_ZSQZ_ZB(15, "保安服务公司设立许可-证书签章（正本）","1,851,614","","SELECT n.id AS 'business_id',n.item_security_z_file AS 'path' FROM tlk_securitysevicek n WHERE n.item_auditStatus='1' AND n.item_security_z_file IS NOT NULL AND n.item_security_z_file != '' AND n.LASTMODIFIED > (NOW() - INTERVAL 3 MINUTE) AND EXISTS(SELECT 1 FROM obpm2_security.signature_queues_document m WHERE m.business_id = n.id and m.business_type='15' AND m.LASTMODIFIED < (NOW() - INTERVAL 3 MINUTE))>0;","tlk_securitysevicek","item_security_z_file"),
    BASLXK_ZSQZ_FB(16, "保安服务公司设立许可-证书签章（副本）","1,264,396","","SELECT n.id AS 'business_id',n.item_security_f_file AS 'path' FROM tlk_securitysevicek n WHERE n.item_auditStatus='1' AND n.item_security_f_file IS NOT NULL AND n.item_security_f_file != '' AND n.LASTMODIFIED > (NOW() - INTERVAL 3 MINUTE) AND EXISTS(SELECT 1 FROM obpm2_security.signature_queues_document m WHERE m.business_id = n.id and m.business_type='16' AND m.LASTMODIFIED < (NOW() - INTERVAL 3 MINUTE))>0;","tlk_securitysevicek","item_security_f_file"),
    MCBG_ZSQZ_ZB(25, "保安服务公司名称变更-证书签章（正本）","1,851,614","","SELECT n.id AS 'business_id',n.item_security_z_file AS 'path' FROM tlk_scope_nameChangeS n WHERE n.item_auditStatus='1' AND n.item_security_z_file IS NOT NULL AND n.item_security_z_file != '' AND n.LASTMODIFIED > (NOW() - INTERVAL 3 MINUTE) AND EXISTS(SELECT 1 FROM obpm2_security.signature_queues_document m WHERE m.business_id = n.id and m.business_type='25' AND m.LASTMODIFIED < (NOW() - INTERVAL 3 MINUTE))>0;","tlk_scope_nameChangeS","item_security_z_file"),
    MCBG_ZSQZ_FB(26, "保安服务公司名称变更-证书签章（副本）","1,264,396","","SELECT n.id AS 'business_id',n.item_security_f_file AS 'path' FROM tlk_scope_nameChangeS n WHERE n.item_auditStatus='1' AND n.item_security_f_file IS NOT NULL AND n.item_security_f_file != '' AND n.LASTMODIFIED > (NOW() - INTERVAL 3 MINUTE) AND EXISTS(SELECT 1 FROM obpm2_security.signature_queues_document m WHERE m.business_id = n.id and m.business_type='26' AND m.LASTMODIFIED < (NOW() - INTERVAL 3 MINUTE))>0;","tlk_scope_nameChangeS","item_security_f_file"),
    DBRBG_ZSQZ_ZB(45, "保安服务公司法定代表人变更-证书签章（正本）","1,851,614","","SELECT n.id AS 'business_id',n.item_security_z_file AS 'path' FROM tlk_LegalChangeK n WHERE n.item_auditStatus='1' AND n.item_security_z_file IS NOT NULL AND n.item_security_z_file != '' AND n.LASTMODIFIED > (NOW() - INTERVAL 3 MINUTE) AND EXISTS(SELECT 1 FROM obpm2_security.signature_queues_document m WHERE m.business_id = n.id and m.business_type='45' AND m.LASTMODIFIED < (NOW() - INTERVAL 3 MINUTE))>0;","tlk_LegalChangeK","item_security_z_file"),
    DBRBG_ZSQZ_FB(46, "保安服务公司法定代表人变更-证书签章（副本）","1,264,396","","SELECT n.id AS 'business_id',n.item_security_f_file AS 'path' FROM tlk_LegalChangeK n WHERE n.item_auditStatus='1' AND n.item_security_f_file IS NOT NULL AND n.item_security_f_file != '' AND n.LASTMODIFIED > (NOW() - INTERVAL 3 MINUTE) AND EXISTS(SELECT 1 FROM obpm2_security.signature_queues_document m WHERE m.business_id = n.id and m.business_type='46' AND m.LASTMODIFIED < (NOW() - INTERVAL 3 MINUTE))>0;","tlk_LegalChangeK","item_security_f_file"),
    ZSBG_ZSQZ_ZB(55, "保安服务公司住所变更-证书签章（正本）","1,851,614","","SELECT n.id AS 'business_id',n.item_security_z_file AS 'path' FROM tlk_scope_addressChangeK n WHERE n.item_auditStatus='1' AND n.item_security_z_file IS NOT NULL AND n.item_security_z_file != '' AND n.LASTMODIFIED > (NOW() - INTERVAL 3 MINUTE) AND EXISTS(SELECT 1 FROM obpm2_security.signature_queues_document m WHERE m.business_id = n.id and m.business_type='55' AND m.LASTMODIFIED < (NOW() - INTERVAL 3 MINUTE))>0;","tlk_scope_addressChangeK","item_security_z_file"),
    ZSBG_ZSQZ_FB(56, "保安服务公司住所变更-证书签章（副本）","1,264,396","","SELECT n.id AS 'business_id',n.item_security_f_file AS 'path' FROM tlk_scope_addressChangeK n WHERE n.item_auditStatus='1' AND n.item_security_f_file IS NOT NULL AND n.item_security_f_file != '' AND n.LASTMODIFIED > (NOW() - INTERVAL 3 MINUTE) AND EXISTS(SELECT 1 FROM obpm2_security.signature_queues_document m WHERE m.business_id = n.id and m.business_type='56' AND m.LASTMODIFIED < (NOW() - INTERVAL 3 MINUTE))>0;","tlk_scope_addressChangeK","item_security_f_file"),
    GHZS_ZSQZ_ZB(65, "更换保安服务许可证-证书签章（正本）","1,851,614","","SELECT n.id AS 'business_id',n.item_security_z_file AS 'path' FROM tlk_securityservicelicensechange n WHERE n.item_auditStatus='1' AND n.item_security_z_file IS NOT NULL AND n.item_security_z_file != '' AND n.LASTMODIFIED > (NOW() - INTERVAL 3 MINUTE) AND EXISTS(SELECT 1 FROM obpm2_security.signature_queues_document m WHERE m.business_id = n.id and m.business_type='65' AND m.LASTMODIFIED < (NOW() - INTERVAL 3 MINUTE))>0;","tlk_securityservicelicensechange","ITEM_SECURITY_Z_FILE"),
    GHZS_ZSQZ_FB(66, "更换保安服务许可证-证书签章（副本）","1,264,396","","SELECT n.id AS 'business_id',n.item_security_f_file AS 'path' FROM tlk_securityservicelicensechange n WHERE n.item_auditStatus='1' AND n.item_security_f_file IS NOT NULL AND n.item_security_f_file != '' AND n.LASTMODIFIED > (NOW() - INTERVAL 3 MINUTE) AND EXISTS(SELECT 1 FROM obpm2_security.signature_queues_document m WHERE m.business_id = n.id and m.business_type='66' AND m.LASTMODIFIED < (NOW() - INTERVAL 3 MINUTE))>0;","tlk_securityservicelicensechange","ITEM_SECURITY_F_FILE");

    private final int value;
    private final String name;
    private final String updateSql;
    private final String selectSql;
    private final String tableName;
    private final String fileField;
    private final String stampXy;

    ResetDocumentType(int value, String name, String stampXy, String updateSql, String selectSql, String tableName, String fileField) {
        this.value = value;
        this.name = name;
        this.stampXy = stampXy;
        this.updateSql = updateSql;
        this.selectSql = selectSql;
        this.tableName = tableName;
        this.fileField = fileField;
    }

    public static ResetDocumentType getByValue(int value) {
        for (ResetDocumentType documentType : ResetDocumentType.values()) {
            if (value==documentType.getValue()) {
                return documentType;
            }
        }
        return null;
    }

    public int getValue() {
        return value;
    }

    public String getName() {
        return name;
    }

    public String getStampXy() {
        return stampXy;
    }

    public String getUpdateSql() {
        return updateSql;
    }

    public String getSelectSql() {
        return selectSql;
    }
    public String getTableName() {
        return tableName;
    }
    public String getFileField() {
        return fileField;
    }
}
