package com.bcxin.backend.domain.enums;

public enum ProcessedStatus implements EnumValue {
    Initialize(0, "初始化"),
    Merged(1, "合并中"),
    Processing(2, "处理中"),
    Done(3, "完成"),
    Error(4, "错误"),
    Retrying(5, "重试中");

    private final int value;
    private final String desc;

    ProcessedStatus(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    @Override
    public int getValue() {
        return 0;
    }

    @Override
    public String getDesc() {
        return null;
    }
}
