package com.bcxin.backend.domain.approval.repositories.source;


import com.bcxin.backend.domain.approval.entities.source.BjApprovalDataEntity;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.stereotype.Repository;

import java.util.Collection;
import java.util.Date;

@Repository
public interface BjApprovalDataRepository extends JpaRepository<BjApprovalDataEntity,String> {
    @Query("select d from BjApprovalDataEntity d where d.lastModified>=?1 and d.createdTime >= '2025-01-01 00:00:00'")
    Collection<BjApprovalDataEntity> findFromDate(Date startDate);


    @Query("select d from BjApprovalDataEntity d where d.createdTime>=?1")
    Collection<BjApprovalDataEntity> findCreatedFromDate(Date date);
}
