/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.backend.domain.signature.service.impls;

import cn.hutool.core.codec.Base64;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.lang.Snowflake;
import cn.hutool.core.lang.UUID;
import cn.hutool.core.util.IdUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.backend.domain.enums.DocumentType;
import com.bcxin.backend.domain.models.SignatureQueuesDTO;
import com.bcxin.backend.domain.models.SignatureQueuesDocument;
import com.bcxin.backend.domain.repositories.SignatureQueuesDocumentRepository;
import com.bcxin.backend.domain.repositories.SignatureQueuesRepository;
import com.bcxin.backend.domain.signature.service.BeiJingInJTLZSignature;
import com.bcxin.backend.domain.utils.FileUtils;
import com.google.common.collect.Maps;
import com.itextpdf.text.Document;
import com.itextpdf.text.pdf.PdfCopy;
import com.itextpdf.text.pdf.PdfImportedPage;
import com.itextpdf.text.pdf.PdfReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Service;

@Service
public class BeiJingInJTLZServiceImpl
implements BeiJingInJTLZSignature {
    private static final Logger log = LoggerFactory.getLogger(BeiJingInJTLZServiceImpl.class);
    private static final Logger logger = LoggerFactory.getLogger(BeiJingInJTLZServiceImpl.class);
    private final SignatureQueuesDocumentRepository signatureQueuesDocumentRepository;
    private final SignatureQueuesRepository signatureQueuesRepository;
    @Value(value="${myapps.domain.url}")
    String urlHead;
    @Value(value="${myapps.storage.root}")
    String rootPath;
    @Value(value="${myapps.signature.ferry_outside}")
    String ferryOutside;
    @Value(value="${myapps.signature.ferry_inside}")
    String ferryInside;
    @Autowired
    @Qualifier(value="primaryJdbcTemplate")
    protected JdbcTemplate jdbcTemplate;
    private static String item_code_bazgz = "10001460100002888X110000";
    private static String item_code_baxkz = "10001440100002888X110000";
    private static String file_suffix = ".bcx";
    private static String write_summary_document_prefix = "INJTLZDOCUMENT-";
    private static String write_summary_prefix = "INJTLZ-";
    private static String write_summary_fz_prefix = "INJTLZFZ-";
    private static int count_jtlz_document = 0;
    private static List<String> fileNames_jtlz_document = null;
    private static int count_jtlz = 0;
    private static List<String> fileNames_jtlz = null;
    private static int count_jtlz_fz = 0;
    private static List<String> fileNames_jtlz_fz = null;
    private final ThreadPoolTaskExecutor taskExecutor;

    public BeiJingInJTLZServiceImpl(SignatureQueuesDocumentRepository signatureQueuesDocumentRepository, SignatureQueuesRepository signatureQueuesRepository, ThreadPoolTaskExecutor taskExecutor) {
        this.signatureQueuesDocumentRepository = signatureQueuesDocumentRepository;
        this.signatureQueuesRepository = signatureQueuesRepository;
        this.taskExecutor = taskExecutor;
    }

    @Override
    public void initJTLZ() {
        try {
            this.createJTLZ();
        }
        catch (Exception e) {
            logger.error("initJTLZ \u4eac\u901a\u9753\u8bc1\u4fe1\u606f", (Throwable)e);
        }
    }

    @Override
    public void initJTLZDocument() {
        try {
            this.createJTLZDocument();
        }
        catch (Exception e) {
            logger.error("initJTLZDocument \u4eac\u901a\u9753\u8bc1\u4fe1\u606f", (Throwable)e);
        }
    }

    @Override
    public void initJTLZFZ() {
        try {
            this.createJTLZFZ();
        }
        catch (Exception e) {
            logger.error("initJTLZFZ \u4eac\u901a\u9753\u8bc1\u4fe1\u606f", (Throwable)e);
        }
    }

    @Override
    public void useJTLZ() {
        this.updateJTLZ();
    }

    @Override
    public void useJTLZFZ() {
        this.updateJTLZFZ();
    }

    private void createJTLZ() {
        long v = System.currentTimeMillis();
        log.error("========> createJTLZ.SignatureQueuesDTO.\u6279\u6b21 star  --------------------- ");
        Page<SignatureQueuesDTO> pageQueues = this.signatureQueuesRepository.pageQueuesBy5Minute(1, PageRequest.of((int)0, (int)70));
        List queues = pageQueues.getContent();
        Snowflake snowflake = IdUtil.createSnowflake((long)1L, (long)1L);
        fileNames_jtlz = new ArrayList<String>();
        count_jtlz = queues.size();
        for (SignatureQueuesDTO dto : queues) {
            this.taskExecutor.execute(() -> {
                try {
                    if (StringUtils.isEmpty((CharSequence)dto.getData()) || StringUtils.isEmpty((CharSequence)dto.getBusiness_id())) {
                        throw new Exception("\u7b7e\u7ae0\u8bb0\u5f55\u6570\u636e\u7f3a\u5931");
                    }
                    String sql = "SELECT item_attachment FROM tlk_certificate WHERE id = '" + dto.getBusiness_id() + "';";
                    List attachment = this.jdbcTemplate.query(sql, (RowMapper)new RowMapper<String>(){

                        public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                            return rs.getString("item_attachment");
                        }
                    });
                    if (attachment.size() == 0 || StringUtils.isEmpty((CharSequence)((CharSequence)attachment.get(0)))) {
                        this.signatureQueuesRepository.updateSignature(0, new Date(), "\u539f\u7535\u5b50\u8bc1\u4e66\u6587\u4ef6\u4e22\u5931\uff0c\u91cd\u65b0\u7b7e\u7ae0", dto.getId());
                        return;
                    }
                    String pdfUrl = this.urlHead + (String)attachment.get(0);
                    String path = this.rootPath + (String)attachment.get(0);
                    Path path1 = Paths.get(path, new String[0]);
                    String fileName = path1.getFileName().toString();
                    String extension = "";
                    int dotIndex = fileName.lastIndexOf(46);
                    if (dotIndex != -1) {
                        extension = fileName.substring(dotIndex + 1);
                    }
                    log.error("========> createJTLZ.SignatureQueuesDTO.pdfUrl\uff1a" + pdfUrl);
                    String base64 = FileUtils.urlToBase64(pdfUrl);
                    if (StringUtils.isEmpty((CharSequence)base64)) {
                        throw new Exception("\u7535\u5b50\u8bc1\u4e66\u8f6c\u6362base64\u5931\u8d25\uff1a" + pdfUrl);
                    }
                    SignatureData signatureData = (SignatureData)JSONObject.parseObject((String)dto.getData(), SignatureData.class);
                    JSONObject data_field = new JSONObject();
                    data_field.put("ZZMC", (Object)"\u4e2d\u534e\u4eba\u6c11\u5171\u548c\u56fd\u4fdd\u5b89\u5458\u8bc1");
                    data_field.put("CYRMC", (Object)signatureData.getName());
                    data_field.put("FZJGZZJGDM", (Object)"1111000000002888XF");
                    data_field.put("FZJGSSXZQHDM", (Object)"110000");
                    data_field.put("CYRSFZJLX", (Object)"10");
                    data_field.put("CYRSFZJHM", (Object)signatureData.getIdcardno().toUpperCase());
                    data_field.put("FZRQ", (Object)DateUtil.formatDate((Date)DateUtil.parseDate((CharSequence)signatureData.getFzDate())));
                    data_field.put("YXQJSRQ", (Object)"");
                    data_field.put("CSRQ", (Object)(signatureData.getYear() + "\u5e74" + signatureData.getMonth() + "\u6708" + signatureData.getDay() + "\u65e5"));
                    data_field.put("ZZ", (Object)signatureData.getAddress());
                    data_field.put("ZP", (Object)"");
                    data_field.put("ZZHM", (Object)signatureData.getCertificateno());
                    data_field.put("FZJGMC", (Object)(StringUtils.isEmpty((CharSequence)signatureData.getCertificatefrom()) ? "\u5317\u4eac\u5e02\u516c\u5b89\u5c40" : signatureData.getCertificatefrom()));
                    log.info("========> createJTLZ.SignatureQueuesDTO\uff1adata_field\uff1a" + JSON.toJSONString((Object)data_field));
                    OperatorData operatorData = OperatorData.fixedOperatorData();
                    ArrayList<FileData> fileDataList = new ArrayList<FileData>();
                    fileDataList.add(new FileData(fileName, extension, base64, "\u9644\u4ef6\u4e3a" + signatureData.getName() + "\uff08\u7f16\u53f7\uff1a" + signatureData.getCertificateno() + "\uff09\u7684\u7535\u5b50\u8d44\u683c\u8bc1\u3002"));
                    String bodyContent = this.license_issue("1111000000002888XF200010910300001", "\u4fdd\u5b89\u5458\u8bc1\u6838\u53d1", "DZYZ00002888XgNbYNa", data_field, operatorData, fileDataList);
                    String fName = "IN-JTLZ-01-" + item_code_bazgz + "-" + dto.getId() + "N" + snowflake.nextId() + file_suffix;
                    fileNames_jtlz.add(fName);
                    FileUtils.writeFile(this.ferryInside, fName, bodyContent);
                    this.signatureQueuesRepository.updateResult(new Date(), "\u9753\u8bc1\u4e2d", dto.getId());
                }
                catch (Exception e) {
                    log.error("========> createJTLZ.SignatureQueuesDTO.server.error: \u3010ID:" + dto.getId() + "\u3011" + e.getMessage() + "    ----");
                }
                finally {
                    --count_jtlz;
                }
            });
        }
        for (int i = 0; count_jtlz > 0 && i != 15; ++i) {
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        log.info("========> createJTLZ.SignatureQueuesDTO.\u6279\u6b21 end  --------------------- ");
        if (fileNames_jtlz.size() > 0) {
            String minuteName = DateUtil.format((Date)new Date(), (String)"yyyyMMddHHmm");
            String writeFtpName = write_summary_prefix + minuteName + file_suffix;
            String body = String.join((CharSequence)",", fileNames_jtlz);
            log.info("========> createJTLZ.file\uff1awriteFtpName\uff1a" + writeFtpName + " \uff0c\u6587\u4ef6\u4e2a\u6570: " + fileNames_jtlz.size() + " ---");
            FileUtils.writeFile(this.ferryInside, writeFtpName, body);
        }
        log.info("========> createJTLZ.end \uff0c\u603b\u8017\u65f6\uff1a" + (System.currentTimeMillis() - v) / 1000L + "\u79d2----------------------------------------");
    }

    private void createJTLZDocument() {
        long v = System.currentTimeMillis();
        log.error("========> createJTLZDocument.\u6279\u6b21 star  --------------------- ");
        Page<SignatureQueuesDocument> pageDocumentQueues = this.signatureQueuesDocumentRepository.pageQueuesBy5Minute(1, PageRequest.of((int)0, (int)30));
        List documentQueues = pageDocumentQueues.getContent();
        Snowflake snowflake = IdUtil.createSnowflake((long)1L, (long)1L);
        log.error("========> createJTLZDocument.size: " + documentQueues.size());
        fileNames_jtlz_document = new ArrayList<String>();
        count_jtlz_document = documentQueues.size();
        for (SignatureQueuesDocument dto : documentQueues) {
            this.taskExecutor.execute(() -> {
                try {
                    SignatureQueuesDocument documentQueueF;
                    String sql = "";
                    if ("15".equals(dto.getBusiness_type())) {
                        sql = "SELECT b.item_comname,a.item_legalCardnumber,b.item_comaddress,b.item_legalname,b.item_fwfw,DATE_FORMAT(b.item_clrq, '%Y-%m-%d') AS item_clrq,DATE_FORMAT(b.item_fzrq, '%Y-%m-%d') AS item_fzrq,b.item_pzwh,b.item_certificatenum,b.item_organname,b.item_registeredcapital,a.item_security_z_file,a.item_security_f_file FROM tlk_securitysevicek a,tlk_companycertificate b WHERE a.id = b.ITEM_SOURCE_ID AND LENGTH(a.item_security_z_file)>0 AND LENGTH(a.item_security_f_file)>0 AND a.id = '" + dto.getBusiness_id() + "';";
                        documentQueueF = this.signatureQueuesDocumentRepository.getSignatureQueuesDocument(dto.getBusiness_id(), "16");
                    } else if ("25".equals(dto.getBusiness_type())) {
                        sql = "SELECT b.item_comname,a.ITEM_LEGAL_CARD_NUM item_legalCardnumber,b.item_comaddress,b.item_legalname,b.item_fwfw,DATE_FORMAT(b.item_clrq, '%Y-%m-%d') AS item_clrq,DATE_FORMAT(b.item_fzrq, '%Y-%m-%d') AS item_fzrq,b.item_pzwh,b.item_certificatenum,b.item_organname,b.item_registeredcapital,a.item_security_z_file,a.item_security_f_file FROM tlk_scope_namechanges a,tlk_companycertificate b WHERE a.id = b.ITEM_SOURCE_ID AND LENGTH(a.item_security_z_file)>0 AND LENGTH(a.item_security_f_file)>0 AND a.id = '" + dto.getBusiness_id() + "';";
                        documentQueueF = this.signatureQueuesDocumentRepository.getSignatureQueuesDocument(dto.getBusiness_id(), "26");
                    } else if ("45".equals(dto.getBusiness_type())) {
                        sql = "SELECT b.item_comname,a.ITEM_APPOINTMENTLEGALCARDNUMBER item_legalCardnumber,b.item_comaddress,b.item_legalname item_legalname,b.item_fwfw,DATE_FORMAT(b.item_clrq, '%Y-%m-%d') AS item_clrq,DATE_FORMAT(b.item_fzrq, '%Y-%m-%d') AS item_fzrq,b.item_pzwh,b.item_certificatenum,b.item_organname,b.item_registeredcapital,a.item_security_z_file,a.item_security_f_file FROM tlk_legalchangek a,tlk_companycertificate b WHERE a.id = b.ITEM_SOURCE_ID AND LENGTH(a.item_security_z_file)>0 AND LENGTH(a.item_security_f_file)>0 AND a.id = '" + dto.getBusiness_id() + "';";
                        documentQueueF = this.signatureQueuesDocumentRepository.getSignatureQueuesDocument(dto.getBusiness_id(), "46");
                    } else if ("55".equals(dto.getBusiness_type())) {
                        sql = "SELECT b.item_comname,a.ITEM_LEGAL_CARD_NUM item_legalCardnumber,b.item_comaddress,b.item_legalname,b.item_fwfw,DATE_FORMAT(b.item_clrq, '%Y-%m-%d') AS item_clrq,DATE_FORMAT(b.item_fzrq, '%Y-%m-%d') AS item_fzrq,b.item_pzwh,b.item_certificatenum,b.item_organname,b.item_registeredcapital,a.item_security_z_file,a.item_security_f_file FROM tlk_scope_addresschangek a,tlk_companycertificate b WHERE a.id = b.ITEM_SOURCE_ID AND LENGTH(a.item_security_z_file)>0 AND LENGTH(a.item_security_f_file)>0 AND a.id = '" + dto.getBusiness_id() + "';";
                        documentQueueF = this.signatureQueuesDocumentRepository.getSignatureQueuesDocument(dto.getBusiness_id(), "56");
                    } else if ("65".equals(dto.getBusiness_type())) {
                        sql = "SELECT b.item_comname,a.ITEM_LEGALIDCARDNUMBER item_legalCardnumber,b.item_comaddress,b.item_legalname,b.item_fwfw,DATE_FORMAT(b.item_clrq, '%Y-%m-%d') AS item_clrq,DATE_FORMAT(b.item_fzrq, '%Y-%m-%d') AS item_fzrq,b.item_pzwh,b.item_certificatenum,b.item_organname,b.item_registeredcapital,a.item_security_z_file,a.item_security_f_file FROM tlk_securityservicelicensechange a,tlk_companycertificate b WHERE a.id = b.ITEM_SOURCE_ID AND LENGTH(a.item_security_z_file)>0 AND LENGTH(a.item_security_f_file)>0 AND a.id = '" + dto.getBusiness_id() + "';";
                        documentQueueF = this.signatureQueuesDocumentRepository.getSignatureQueuesDocument(dto.getBusiness_id(), "66");
                    } else {
                        return;
                    }
                    log.error("========> createJTLZDocument.SignatureQueuesDocument.sql: " + sql);
                    List attachment = this.jdbcTemplate.query(sql, (RowMapper)new RowMapper<Map<String, String>>(){

                        public Map<String, String> mapRow(ResultSet rs, int rowNum) throws SQLException {
                            HashMap map = Maps.newHashMap();
                            map.put("item_comname", rs.getString("item_comname"));
                            map.put("item_legalCardnumber", rs.getString("item_legalCardnumber").trim());
                            map.put("item_comaddress", rs.getString("item_comaddress"));
                            map.put("item_legalname", rs.getString("item_legalname"));
                            map.put("item_fwfw", BeiJingInJTLZServiceImpl.this.formatManagement(rs.getString("item_fwfw")));
                            map.put("item_clrq", rs.getString("item_clrq"));
                            map.put("item_fzrq", rs.getString("item_fzrq"));
                            map.put("item_pzwh", rs.getString("item_pzwh"));
                            map.put("item_certificatenum", rs.getString("item_certificatenum"));
                            map.put("item_organname", rs.getString("item_organname"));
                            map.put("item_registeredcapital", rs.getString("item_registeredcapital"));
                            map.put("item_security_z_file", rs.getString("item_security_z_file"));
                            map.put("item_security_f_file", rs.getString("item_security_f_file"));
                            return map;
                        }
                    });
                    if (attachment.size() == 0 || attachment.get(0) == null) {
                        throw new Exception("\u8bc1\u4e66\u8bb0\u5f55\u4e0d\u5b58\u5728");
                    }
                    Map attachmentMap = (Map)attachment.get(0);
                    String item_security_z_file = dto.getFile_url();
                    String item_security_f_file = documentQueueF.getFile_url();
                    if (StringUtils.isEmpty((CharSequence)item_security_z_file) || StringUtils.isEmpty((CharSequence)item_security_f_file)) {
                        throw new Exception("\u7535\u5b50\u8bc1\u4e66\u5730\u5740\u4e0d\u5b58\u5728");
                    }
                    if (StringUtils.isEmpty((CharSequence)((CharSequence)attachmentMap.get("item_legalCardnumber")))) {
                        throw new Exception("\u6cd5\u4eba\u8eab\u4efd\u8bc1\u53f7\u4e0d\u5b58\u5728");
                    }
                    String pathZ = this.rootPath + item_security_z_file;
                    String pathF = this.rootPath + item_security_f_file;
                    String fileName = (String)attachmentMap.get("item_comname") + "\uff08\u7f16\u53f7\uff1a" + (String)attachmentMap.get("item_pzwh") + "\uff09\u7684\u7535\u5b50\u4fdd\u5b89\u670d\u52a1\u8bb8\u53ef\u8bc1";
                    String outpdf = this.rootPath + "/uploads/pdf/documenttemp/" + DateUtil.today() + "/" + fileName + ".pdf";
                    BeiJingInJTLZServiceImpl.mergePdf(pathZ, pathF, outpdf);
                    String base64 = FileUtils.fileToBase64(outpdf);
                    new File(outpdf).delete();
                    if (StringUtils.isEmpty((CharSequence)base64)) {
                        throw new Exception("\u7535\u5b50\u8bc1\u4e66\u6b63\u526f\u672c\u5408\u5e76\u540e\u8f6c\u6362base64\u5931\u8d25\uff1a" + outpdf);
                    }
                    String certificatenum = (String)attachmentMap.get("item_certificatenum");
                    if (StringUtils.isNotEmpty((CharSequence)certificatenum)) {
                        if (!certificatenum.contains("\u4eac\u516c\u4fdd\u670d")) {
                            certificatenum = "\u4eac\u516c\u4fdd\u670d" + certificatenum;
                        }
                        if (!certificatenum.contains("\u53f7")) {
                            certificatenum = certificatenum + "\u53f7";
                        }
                    }
                    JSONObject data_field = new JSONObject();
                    data_field.put("ZZMC", (Object)"\u4fdd\u5b89\u670d\u52a1\u8bb8\u53ef\u8bc1");
                    data_field.put("FZJGZZJGDM", (Object)"1111000000002888XF");
                    data_field.put("FZJGSSXZQHDM", (Object)"110000");
                    data_field.put("YXQJSRQ", (Object)"");
                    data_field.put("ZZHM", (Object)certificatenum);
                    data_field.put("CYRMC", attachmentMap.get("item_comname"));
                    data_field.put("CYRSFZJLX", (Object)"80");
                    data_field.put("CYRSFZJHM", attachmentMap.get("item_legalCardnumber"));
                    data_field.put("XKZZJH", (Object)certificatenum);
                    data_field.put("FR", attachmentMap.get("item_legalname"));
                    data_field.put("FZJGMC", attachmentMap.get("item_organname"));
                    data_field.put("FZRQ", attachmentMap.get("item_fzrq"));
                    data_field.put("ZS", attachmentMap.get("item_comaddress"));
                    data_field.put("FWFW", attachmentMap.get("item_fwfw"));
                    data_field.put("PZWH", attachmentMap.get("item_pzwh"));
                    data_field.put("ZCZB", (Object)(StringUtils.isEmpty((CharSequence)((CharSequence)attachmentMap.get("item_registeredcapital"))) ? "0.00" : attachmentMap.get("item_registeredcapital")));
                    log.error("========> createJTLZDocument.SignatureQueuesDocument.data_field: " + data_field.toJSONString());
                    OperatorData operatorData = OperatorData.fixedOperatorData();
                    ArrayList<FileData> fileDataList = new ArrayList<FileData>();
                    fileDataList.add(new FileData(fileName + ".pdf", "pdf", base64, fileName));
                    String bodyContent = this.license_issue("1111000000002888XF200010910200101", "\u4fdd\u5b89\u670d\u52a1\u516c\u53f8\u8bbe\u7acb\u8bb8\u53ef", "DZYZ00002888XfxlBdz", data_field, operatorData, fileDataList);
                    String fName = "IN-JTLZ-15-" + item_code_baxkz + "-" + dto.getId() + "N" + snowflake.nextId() + file_suffix;
                    fileNames_jtlz_document.add(fName);
                    FileUtils.writeFile(this.ferryInside, fName, bodyContent);
                    log.info("========> createJTLZDocument.server15.filename: " + fName + "    end----");
                }
                catch (Exception e) {
                    log.error("========> createJTLZDocument.server.error: " + e.getMessage() + "    ----");
                }
                finally {
                    --count_jtlz_document;
                }
            });
        }
        for (int i = 0; count_jtlz_document > 0 && i != 15; ++i) {
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        log.error("========> createJTLZDocument.\u6279\u6b21 end  --------------------- ");
        if (fileNames_jtlz_document.size() > 0) {
            for (int sleepCount = 30; sleepCount > 0; --sleepCount) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                List<File> files = FileUtils.filenames(this.ferryInside, "IN-JTLZ-15-");
                if (files.size() != 0) continue;
                log.error("========> createJTLZDocument.\u6279\u6b21 \u6d88\u8017\u81f3\uff1a" + sleepCount + "\uff01  --------------------- ");
                break;
            }
            String minuteName = DateUtil.format((Date)new Date(), (String)"yyyyMMddHHmm");
            String writeFtpName = write_summary_document_prefix + minuteName + file_suffix;
            String body = String.join((CharSequence)",", fileNames_jtlz_document);
            log.error("========> createJTLZDocument.file\uff1awriteFtpName\uff1a" + writeFtpName + " \uff0c\u6587\u4ef6\u4e2a\u6570: " + fileNames_jtlz_document.size() + " ---");
            FileUtils.writeFile(this.ferryInside, writeFtpName, body);
        }
        log.info("========> createJTLZDocument.end \uff0c\u603b\u8017\u65f6\uff1a" + (System.currentTimeMillis() - v) / 1000L + "\u79d2----------------------------------------");
    }

    private static void mergePdf(String inpdf1, String inpdf2, String outpdf) throws Exception {
        if (StringUtils.isEmpty((CharSequence)inpdf1)) {
            throw new FileNotFoundException("Font file not found: " + inpdf1);
        }
        File file = new File(outpdf);
        if (!file.exists()) {
            FileUtil.touch((File)file);
        }
        Document document = new Document();
        PdfCopy copy = new PdfCopy(document, (OutputStream)new FileOutputStream(outpdf));
        document.open();
        PdfReader reader1 = new PdfReader(inpdf1);
        PdfImportedPage page1 = copy.getImportedPage(reader1, 1);
        copy.addPage(page1);
        if (StringUtils.isNotEmpty((CharSequence)inpdf2)) {
            document.newPage();
            PdfReader reader2 = new PdfReader(inpdf2);
            PdfImportedPage page2 = copy.getImportedPage(reader2, 1);
            copy.addPage(page2);
        }
        document.close();
    }

    private String formatManagement(String fwfw) {
        if (StringUtils.isEmpty((CharSequence)fwfw)) {
            return "";
        }
        StringBuffer management = new StringBuffer();
        String[] orders = new String[]{"01", "02", "03", "04", "05", "06", "07", "08", "09"};
        String[] ss = fwfw.split(";");
        for (int j = 0; j < orders.length; ++j) {
            for (int i = 0; i < ss.length; ++i) {
                if (!orders[j].equals(ss[i])) continue;
                if ("01".equals(ss[i])) {
                    management.append("\u95e8\u536b\u3001");
                    continue;
                }
                if ("02".equals(ss[i])) {
                    management.append("\u5de1\u903b\u3001");
                    continue;
                }
                if ("03".equals(ss[i])) {
                    management.append("\u5b88\u62a4\u3001");
                    continue;
                }
                if ("05".equals(ss[i])) {
                    management.append("\u968f\u8eab\u62a4\u536b\u3001");
                    continue;
                }
                if ("04".equals(ss[i])) {
                    management.append("\u6b66\u88c5\u62bc\u8fd0\u3001");
                    continue;
                }
                if ("07".equals(ss[i])) continue;
                if ("05".equals(ss[i])) {
                    management.append("\u5b89\u5168\u68c0\u67e5\u3001");
                    continue;
                }
                if ("08".equals(ss[i])) {
                    management.append("\u5b89\u5168\u98ce\u9669\u8bc4\u4f30\u3001");
                    continue;
                }
                if ("09".equals(ss[i])) {
                    management.append("\u5b89\u5168\u6280\u672f\u9632\u8303\u3001");
                    continue;
                }
                if (!"10".equals(ss[i])) continue;
            }
        }
        return management.toString().substring(0, management.toString().length() - 1);
    }

    private String license_issue(String serviceCode, String serviceName, String sealCode, JSONObject data_field, OperatorData operatorData, List<FileData> fileDataList) {
        String license_code = "";
        try {
            JSONObject data = new JSONObject();
            JSONObject json = new JSONObject();
            json.put("service_item_code", (Object)serviceCode);
            json.put("service_item_name", (Object)serviceName);
            json.put("license_group", (Object)"\u7ec4\u522b1");
            json.put("biz_num", (Object)UUID.randomUUID().toString());
            JSONObject operator = new JSONObject();
            operator.put("account", (Object)operatorData.getAccount());
            operator.put("name", (Object)operatorData.getName());
            operator.put("identity_num", (Object)operatorData.getIdcardno());
            operator.put("role", (Object)operatorData.getRoleName());
            operator.put("service_org", (Object)operatorData.getOrgName());
            operator.put("division", (Object)operatorData.getRegionName());
            operator.put("division_code", (Object)operatorData.getRegionCode());
            json.put("operator", (Object)operator);
            json.put("data_fields", (Object)data_field);
            json.put("seal_code", (Object)sealCode);
            json.put("sign_attach", (Object)false);
            JSONArray attachments = new JSONArray();
            for (FileData fileData : fileDataList) {
                JSONObject attachment = new JSONObject();
                attachment.put("is_show_template", (Object)"true");
                attachment.put("is_license_image", (Object)"true");
                attachment.put("file_type", (Object)fileData.getFiletype());
                attachment.put("name", (Object)fileData.getFilename());
                attachment.put("description", (Object)fileData.getDescription());
                attachment.put("file_data", (Object)fileData.getFilebase64());
                attachments.add((Object)attachment);
            }
            json.put("attachments", (Object)attachments);
            data.put("data", (Object)json);
            String body = data.toJSONString();
            return body;
        }
        catch (Exception e) {
            log.error("====> \u4eac\u901a\u9753\u8bc1\u4fe1\u606f\u63a8\u9001\u5b9a\u65f6\u4efb\u52a1.license_issue.error:", (Throwable)e);
            return license_code;
        }
    }

    private void createJTLZFZ() {
        int i;
        Page<SignatureQueuesDTO> pageQueues = this.signatureQueuesRepository.pageQueuesByCodeFZ(1, PageRequest.of((int)0, (int)30));
        List queues = pageQueues.getContent();
        fileNames_jtlz_fz = new ArrayList<String>();
        count_jtlz_fz = queues.size();
        for (SignatureQueuesDTO dto : queues) {
            this.taskExecutor.execute(() -> {
                try {
                    if (StringUtils.isEmpty((CharSequence)dto.getData()) || StringUtils.isEmpty((CharSequence)dto.getBusiness_id())) {
                        throw new Exception("\u7b7e\u7ae0\u8bb0\u5f55\u6570\u636e\u7f3a\u5931");
                    }
                    SignatureData signatureData = (SignatureData)JSONObject.parseObject((String)dto.getData(), SignatureData.class);
                    String bodyContent = this.license_issue_fz("1111000000002888XF200010910300001", "\u4fdd\u5b89\u5458\u8bc1\u6838\u53d1", signatureData.getCertificateno());
                    String fName = "IN-JTLZFZ-01-" + item_code_bazgz + "-" + dto.getId() + file_suffix;
                    fileNames_jtlz_fz.add(fName);
                    FileUtils.writeFile(this.ferryInside, fName, bodyContent);
                    log.error("========> createJTLZFZ.server01.filename: " + fName + "    end----");
                }
                catch (Exception e) {
                    log.error("========> createJTLZFZ.SignatureQueues.server.error: " + e.getMessage() + "    ----");
                }
                finally {
                    --count_jtlz_fz;
                }
            });
        }
        for (i = 0; count_jtlz_fz > 0 && i != 15; ++i) {
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        Page<SignatureQueuesDocument> pageDocumentQueues = this.signatureQueuesDocumentRepository.pageQueuesByCodeFZ(1, PageRequest.of((int)0, (int)30));
        List documentQueues = pageDocumentQueues.getContent();
        log.error("========> createJTLZFZ.documentQueues.size: " + documentQueues.size());
        count_jtlz_fz = documentQueues.size();
        for (SignatureQueuesDocument dto : documentQueues) {
            this.taskExecutor.execute(() -> {
                try {
                    DocumentType dt = DocumentType.getByValue(Integer.parseInt(dto.getBusiness_type()));
                    String sql = "SELECT b.item_certificatenum FROM " + dt.getTableName() + " a,tlk_companycertificate b WHERE a.id = b.ITEM_SOURCE_ID AND a.id = '" + dto.getBusiness_id() + "';";
                    List certificatenums = this.jdbcTemplate.query(sql, (RowMapper)new RowMapper<String>(){

                        public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                            return rs.getString("item_certificatenum");
                        }
                    });
                    if (certificatenums.size() == 0 || certificatenums.get(0) == null) {
                        throw new Exception("\u65e0\u6709\u6548\u8bc1\u4e66\u7f16\u53f7");
                    }
                    String certificatenum = (String)certificatenums.get(0);
                    log.error("========> createJTLZFZ.documentQueues.certificatenum: " + certificatenum);
                    String bodyContent = this.license_issue_fz("1111000000002888XF200010910200101", "\u4fdd\u5b89\u670d\u52a1\u516c\u53f8\u8bbe\u7acb\u8bb8\u53ef", certificatenum);
                    String fName = "IN-JTLZFZ-15-" + item_code_baxkz + "-" + dto.getId() + file_suffix;
                    fileNames_jtlz_fz.add(fName);
                    FileUtils.writeFile(this.ferryInside, fName, bodyContent);
                    log.error("========> createJTLZFZ.server15.filename: " + fName + "    end----");
                }
                catch (Exception e) {
                    log.error("========> createJTLZFZ.SignatureQueuesDocument.server.error: businessId={}; url={}----", new Object[]{dto.getBusiness_id(), dto.getFile_url(), e});
                }
                finally {
                    --count_jtlz_fz;
                }
            });
        }
        for (i = 0; count_jtlz_fz > 0 && i != 15; ++i) {
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        if (fileNames_jtlz_fz.size() > 0) {
            String minuteName = DateUtil.format((Date)new Date(), (String)"yyyyMMddHHmm");
            String writeFtpName = write_summary_fz_prefix + minuteName + file_suffix;
            String body = String.join((CharSequence)",", fileNames_jtlz_fz);
            log.error("========> createJTLZ.file:writeFtpName:" + writeFtpName + " ,body: " + body + " ---");
            FileUtils.writeFile(this.ferryInside, writeFtpName, body);
        }
        log.error("========> createJTLZ.end ----------------------------------------");
    }

    private String license_issue_fz(String serviceCode, String serviceName, String idCode) {
        log.error("====> \u4eac\u901a\u9753\u8bc1\u4fe1\u606f\u5e9f\u6b62\u5b9a\u65f6\u4efb\u52a1.license_issue_fz.star---------");
        String license_code = "";
        try {
            OperatorData operatorData = OperatorData.fixedOperatorData();
            JSONObject data = new JSONObject();
            JSONObject json = new JSONObject();
            json.put("id_code", (Object)idCode);
            json.put("service_item_code", (Object)serviceCode);
            json.put("service_item_name", (Object)serviceName);
            json.put("biz_num", (Object)UUID.randomUUID().toString());
            JSONObject operator = new JSONObject();
            operator.put("account", (Object)operatorData.getAccount());
            operator.put("name", (Object)operatorData.getName());
            operator.put("identity_num", (Object)operatorData.getIdcardno());
            operator.put("role", (Object)operatorData.getRoleName());
            operator.put("service_org", (Object)operatorData.getOrgName());
            operator.put("division", (Object)operatorData.getRegionName());
            operator.put("division_code", (Object)operatorData.getRegionCode());
            json.put("operator", (Object)operator);
            data.put("data", (Object)json);
            String body = data.toJSONString();
            log.error("====> \u4eac\u901a\u9753\u8bc1\u4fe1\u606f\u5e9f\u6b62\u5b9a\u65f6\u4efb\u52a1.license_issue_fz.\u8bf7\u6c42\u62a5\u6587\uff1a" + body);
            return body;
        }
        catch (Exception e) {
            log.error("====> \u4eac\u901a\u9753\u8bc1\u4fe1\u606f\u5e9f\u6b62\u5b9a\u65f6\u4efb\u52a1.license_issue_fz.error:" + e.getMessage());
            return license_code;
        }
    }

    public static String fileUUIDName(String filePath) {
        Path path = Paths.get(filePath, new String[0]);
        String fileName = path.getFileName().toString();
        int lastDotIndex = fileName.lastIndexOf(46);
        if (lastDotIndex > 0 && lastDotIndex < fileName.length() - 1) {
            String fileExtension = UUID.randomUUID().toString() + "." + fileName.substring(lastDotIndex + 1);
            return fileExtension;
        }
        return "";
    }

    private static String copyFile(String originalFilePath, String rootPath) {
        try {
            Path sourcePath = Paths.get(rootPath + originalFilePath, new String[0]);
            String fileName = sourcePath.getFileName().toString();
            String fileExtension = BeiJingInJTLZServiceImpl.getFileExtension(fileName);
            String newFileName = UUID.randomUUID().toString() + "." + fileExtension;
            Path targetPath = sourcePath.getParent().resolve(newFileName);
            Files.copy(sourcePath, targetPath, StandardCopyOption.REPLACE_EXISTING);
            String newPath = targetPath.toString().replace(rootPath, "");
            System.out.println("\u6587\u4ef6\u590d\u5236\u6210\u529f\uff01\u65b0\u6587\u4ef6\u8def\u5f84: " + newPath);
            return newPath;
        }
        catch (Exception e) {
            logger.error("\u6587\u4ef6\u590d\u5236\u5931\u8d25", (Throwable)e);
            return "";
        }
    }

    private static String getFileExtension(String fileName) {
        int lastIndexOfDot = fileName.lastIndexOf(46);
        if (lastIndexOfDot == -1) {
            return "";
        }
        return fileName.substring(lastIndexOfDot + 1);
    }

    private void updateJTLZ() {
        List<File> files = FileUtils.filenames(this.ferryOutside, "OUT-JTLZ-");
        log.error("====> \u89e3\u6790\u9753\u8bc1\u7ed3\u679c\u5b9a\u65f6\u4efb\u52a1.updateJTLZ.files\uff1a" + files.size());
        for (File file : files) {
            String filename = file.getName();
            String[] arr = filename.replace(file_suffix, "").split("-");
            String type = arr[2];
            String id = arr[4];
            if (id.contains("N")) {
                id = id.split("N")[0];
            }
            log.error("====> \u89e3\u6790\u9753\u8bc1\u7ed3\u679c\u5b9a\u65f6\u4efb\u52a1.updateJTLZ.filename\uff1a" + filename);
            if (!"01".equals(type) && !"15".equals(type)) {
                log.error("====> \u89e3\u6790\u9753\u8bc1\u7ed3\u679c\u5b9a\u65f6\u4efb\u52a1.updateJTLZ.filename\uff1a\u6587\u4ef6\u7c7b\u578b\u4e0d\u5b58\u5728");
                continue;
            }
            String content = FileUtil.readString((File)file, (Charset)StandardCharsets.UTF_8);
            if (StringUtils.isEmpty((CharSequence)content)) {
                log.error("====> \u89e3\u6790\u9753\u8bc1\u7ed3\u679c\u5b9a\u65f6\u4efb\u52a1.updateJTLZ.fail\uff1atype=" + type + ",id=" + id + " end");
                if ("01".equals(type)) {
                    this.signatureQueuesRepository.updateJtCode("", new Date(), "\u9753\u8bc1\u5931\u8d25\uff0c\u8bf7\u624b\u52a8\u8bbe\u7f6e\u6700\u540e\u4fee\u6539\u65f6\u95f4\u4e3a\u5f53\u524d\u8fdb\u884c\u91cd\u8bd5", id);
                    continue;
                }
                if (!"15".equals(type)) continue;
                this.signatureQueuesDocumentRepository.updateJtCode("", new Date(), "\u9753\u8bc1\u5931\u8d25\uff0c\u8bf7\u624b\u52a8\u8bbe\u7f6e\u6700\u540e\u4fee\u6539\u65f6\u95f4\u4e3a\u5f53\u524d\u8fdb\u884c\u91cd\u8bd5", Long.parseLong(id));
                continue;
            }
            log.error("====> \u89e3\u6790\u9753\u8bc1\u7ed3\u679c\u5b9a\u65f6\u4efb\u52a1.updateJTLZ.result\uff1a" + content);
            FileUtil.del((File)file);
            log.error("====> \u89e3\u6790\u9753\u8bc1\u7ed3\u679c\u5b9a\u65f6\u4efb\u52a1.updateJTLZ.\u5220\u9664\u6587\u4ef6\uff1a" + filename);
            try {
                JSONObject json = JSONObject.parseObject((String)content);
                if ("FAILURE".equals(json.getString("ack_code"))) {
                    JSONObject errObj;
                    JSONArray jsonArray;
                    String errJson = json.getString("errors");
                    if ("01".equals(type)) {
                        if (errJson.contains("\u5b58\u5728\u91cd\u590d\u7684\u7535\u5b50\u8bc1\u7167")) {
                            String finalId = id;
                            new Thread(() -> {
                                String data = this.signatureQueuesRepository.getData(finalId);
                                SignatureData signatureData = (SignatureData)JSONObject.parseObject((String)data, SignatureData.class);
                                List<SignatureQueuesDTO> list = this.signatureQueuesRepository.findByDataLike("%" + signatureData.getCertificateno() + "%");
                                String jtCode = finalId + "YES";
                                for (SignatureQueuesDTO dto1 : list) {
                                    if (!StringUtils.isNotEmpty((CharSequence)dto1.getJt_code()) || dto1.getJt_code().contains("YES")) continue;
                                    jtCode = dto1.getJt_code();
                                }
                                log.error("====> \u89e3\u6790\u9753\u8bc1\u7ed3\u679c\u5b9a\u65f6\u4efb\u52a1.updateJTLZ.\u91cd\u590d\u7684\u7535\u5b50\u8bc1\u7167.jtCode\uff1a" + jtCode);
                                for (SignatureQueuesDTO dto1 : list) {
                                    if (!StringUtils.isEmpty((CharSequence)dto1.getJt_code()) && !dto1.getJt_code().contains("YES")) continue;
                                    this.signatureQueuesRepository.updateJtCode(jtCode, new Date(), "\u5b8c\u6210\u9753\u8bc1:\u5b58\u5728\u91cd\u590d\u7684\u7535\u5b50\u8bc1\u7167\uff08\u65e0\u9700\u91cd\u65b0\u9753\u8bc1\uff09", dto1.getId());
                                }
                            }).start();
                            continue;
                        }
                        if ("[]".equals(errJson)) {
                            this.signatureQueuesRepository.updateJtCode("", new Date(), "\u9753\u8bc1\u5931\u8d25:\u5f02\u5e38\u4fe1\u606f\u4e3a\u7a7a", id);
                            continue;
                        }
                        jsonArray = JSONArray.parseArray((String)errJson);
                        errObj = (JSONObject)jsonArray.get(0);
                        this.signatureQueuesRepository.updateJtCode("", new Date(), "\u9753\u8bc1\u5931\u8d25:" + errObj.getString("message"), id);
                        continue;
                    }
                    if (!"15".equals(type)) continue;
                    if (errJson.contains("\u5b58\u5728\u91cd\u590d\u7684\u7535\u5b50\u8bc1\u7167")) {
                        String finalId1 = id;
                        new Thread(() -> {
                            String jtCode = finalId1 + "YES";
                            this.signatureQueuesDocumentRepository.updateJtCode(jtCode, new Date(), "\u5b8c\u6210\u9753\u8bc1:\u5b58\u5728\u91cd\u590d\u7684\u7535\u5b50\u8bc1\u7167\uff08\u65e0\u9700\u91cd\u65b0\u9753\u8bc1\uff09", Long.parseLong(finalId1));
                        }).start();
                        continue;
                    }
                    if ("[]".equals(errJson)) {
                        this.signatureQueuesDocumentRepository.updateJtCode("", new Date(), "\u9753\u8bc1\u5931\u8d25:\u5f02\u5e38\u4fe1\u606f\u4e3a\u7a7a", Long.parseLong(id));
                        continue;
                    }
                    jsonArray = JSONArray.parseArray((String)errJson);
                    errObj = (JSONObject)jsonArray.get(0);
                    this.signatureQueuesDocumentRepository.updateJtCode("", new Date(), "\u9753\u8bc1\u5931\u8d25:" + errObj.getString("message"), Long.parseLong(id));
                    continue;
                }
                JSONObject data = (JSONObject)json.getObject("data", JSONObject.class);
                String jtcode = data.getString("auth_code");
                if (StringUtils.isEmpty((CharSequence)jtcode)) {
                    log.error("====> \u89e3\u6790\u9753\u8bc1\u7ed3\u679c\u5b9a\u65f6\u4efb\u52a1.updateJTLZ.fail\uff1alicense_code=null,type=" + type + ",id=" + id + " end");
                    if ("01".equals(type)) {
                        this.signatureQueuesRepository.updateJtCode("", new Date(), "\u9753\u8bc1\u5931\u8d25:\u9753\u8bc1\u7f16\u53f7\u4e22\u5931", id);
                        continue;
                    }
                    if (!"15".equals(type)) continue;
                    this.signatureQueuesDocumentRepository.updateJtCode("", new Date(), "\u9753\u8bc1\u5931\u8d25:\u9753\u8bc1\u7f16\u53f7\u4e22\u5931", Long.parseLong(id));
                    continue;
                }
                if ("01".equals(type)) {
                    this.signatureQueuesRepository.updateJtCode(jtcode, new Date(), "\u5b8c\u6210\u9753\u8bc1", id);
                } else if ("15".equals(type)) {
                    this.signatureQueuesDocumentRepository.updateJtCode(jtcode, new Date(), "\u5b8c\u6210\u9753\u8bc1", Long.parseLong(id));
                }
                log.error("====> \u89e3\u6790\u9753\u8bc1\u7ed3\u679c\u5b9a\u65f6\u4efb\u52a1.updateJTLZ.success\uff1aend");
            }
            catch (Exception e) {
                log.error("====> \u89e3\u6790\u9753\u8bc1\u7ed3\u679c\u5b9a\u65f6\u4efb\u52a1.updateJTLZ.fail\uff1a" + e.getMessage());
            }
        }
    }

    private void updateJTLZFZ() {
        List<File> files = FileUtils.filenames(this.ferryOutside, "OUT-JTLZFZ-");
        log.error("====> \u89e3\u6790\u9753\u8bc1\u5e9f\u6b62\u7ed3\u679c\u5b9a\u65f6\u4efb\u52a1.updateJTLZFZ.files\uff1a" + files.size());
        for (File file : files) {
            String filename = file.getName();
            String[] arr = filename.replace(file_suffix, "").split("-");
            String type = arr[2];
            String id = arr[4];
            log.error("====> \u89e3\u6790\u9753\u8bc1\u5e9f\u6b62\u7ed3\u679c\u5b9a\u65f6\u4efb\u52a1.updateJTLZFZ.filename\uff1a" + filename);
            if (!"01".equals(type) && !"15".equals(type)) {
                log.error("====> \u89e3\u6790\u9753\u8bc1\u5e9f\u6b62\u7ed3\u679c\u5b9a\u65f6\u4efb\u52a1.updateJTLZFZ.filename\uff1a\u6587\u4ef6\u7c7b\u578b\u4e0d\u5b58\u5728");
                continue;
            }
            String content = FileUtil.readString((File)file, (Charset)StandardCharsets.UTF_8);
            if (StringUtils.isEmpty((CharSequence)content)) {
                log.error("====> \u89e3\u6790\u9753\u8bc1\u5e9f\u6b62\u7ed3\u679c\u5b9a\u65f6\u4efb\u52a1.updateJTLZFZ.fail\uff1atype=" + type + ",id=" + id + " end");
                if ("01".equals(type)) {
                    this.signatureQueuesRepository.updateJtCode("\u5e9f\u6b62", new Date(), "\u9753\u8bc1\u5e9f\u6b62\u5931\u8d25\uff0c\u65e0\u6709\u6548\u8fd4\u56de", id);
                    continue;
                }
                if (!"15".equals(type)) continue;
                this.signatureQueuesDocumentRepository.updateJtCode("\u5e9f\u6b62", new Date(), "\u9753\u8bc1\u5e9f\u6b62\u5931\u8d25\uff0c\u65e0\u6709\u6548\u8fd4\u56de", Long.parseLong(id));
                continue;
            }
            log.error("====> \u89e3\u6790\u9753\u8bc1\u5e9f\u6b62\u7ed3\u679c\u5b9a\u65f6\u4efb\u52a1.updateJTLZFZ.result\uff1a" + content);
            FileUtil.del((File)file);
            log.error("====> \u89e3\u6790\u9753\u8bc1\u5e9f\u6b62\u7ed3\u679c\u5b9a\u65f6\u4efb\u52a1.updateJTLZFZ.\u5220\u9664\u6587\u4ef6\uff1a" + filename);
            try {
                JSONObject json = JSONObject.parseObject((String)content);
                if ("FAILURE".equals(json.getString("ack_code"))) {
                    String errJson = json.getString("errors");
                    JSONArray jsonArray = JSONArray.parseArray((String)errJson);
                    JSONObject errObj = (JSONObject)jsonArray.get(0);
                    String msg = errObj.getString("message");
                    if ("01".equals(type)) {
                        if (StringUtils.isNotEmpty((CharSequence)msg) && (msg.contains("\u8be5\u7535\u5b50\u8bc1\u7167\u4e0d\u5b58\u5728") || msg.contains("\u6587\u4ef6\u4e0d\u5b58\u5728\u6216\u5185\u5bb9\u4e3a\u7a7a"))) {
                            this.signatureQueuesRepository.updateJtCode("", new Date(), "\u9753\u8bc1\u5e9f\u6b62\u5931\u8d25:" + msg, id);
                            continue;
                        }
                        this.signatureQueuesRepository.updateJtCode("\u5e9f\u6b62", new Date(), "\u9753\u8bc1\u5e9f\u6b62\u5931\u8d25:" + msg, id);
                        continue;
                    }
                    if (!"15".equals(type)) continue;
                    if (StringUtils.isNotEmpty((CharSequence)msg) && (msg.contains("\u8be5\u7535\u5b50\u8bc1\u7167\u4e0d\u5b58\u5728") || msg.contains("\u6587\u4ef6\u4e0d\u5b58\u5728\u6216\u5185\u5bb9\u4e3a\u7a7a"))) {
                        this.signatureQueuesDocumentRepository.updateJtCode("", new Date(), "\u9753\u8bc1\u5e9f\u6b62\u5931\u8d25:" + msg, Long.parseLong(id));
                        continue;
                    }
                    this.signatureQueuesDocumentRepository.updateJtCode("\u5e9f\u6b62", new Date(), "\u9753\u8bc1\u5e9f\u6b62\u5931\u8d25:" + msg, Long.parseLong(id));
                    continue;
                }
                if ("01".equals(type)) {
                    this.signatureQueuesRepository.updateJtCode("", new Date(), "\u9753\u8bc1\u5e9f\u6b62\u6210\u529f:\u91cd\u65b0\u9753\u8bc1", id);
                } else if ("15".equals(type)) {
                    this.signatureQueuesDocumentRepository.updateJtCode("", new Date(), "\u9753\u8bc1\u5e9f\u6b62\u6210\u529f:\u91cd\u65b0\u9753\u8bc1", Long.parseLong(id));
                }
                log.error("====> \u89e3\u6790\u9753\u8bc1\u5e9f\u6b62\u7ed3\u679c\u5b9a\u65f6\u4efb\u52a1.updateJTLZFZ.success\uff1aend");
            }
            catch (Exception e) {
                log.error("====> \u89e3\u6790\u9753\u8bc1\u5e9f\u6b62\u7ed3\u679c\u5b9a\u65f6\u4efb\u52a1.updateJTLZFZ.fail\uff1a" + e.getMessage());
            }
        }
    }

    public static boolean base64ToFile(String base64String, String filePath) {
        try {
            byte[] bytes = Base64.decode((CharSequence)base64String);
            File file = FileUtil.file((String)filePath);
            try (FileOutputStream fos = new FileOutputStream(file);){
                IoUtil.write((OutputStream)fos, (boolean)true, (byte[])bytes);
            }
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static class FileData {
        private String filename;
        private String filetype;
        private String filebase64;
        private String description;

        public FileData(String filename, String filetype, String filebase64, String description) {
            this.filename = filename;
            this.filetype = filetype;
            this.filebase64 = filebase64;
            this.description = description;
        }

        public String getFilename() {
            return this.filename;
        }

        public String getFiletype() {
            return this.filetype;
        }

        public String getFilebase64() {
            return this.filebase64;
        }

        public String getDescription() {
            return this.description;
        }

        public void setFilename(String filename) {
            this.filename = filename;
        }

        public void setFiletype(String filetype) {
            this.filetype = filetype;
        }

        public void setFilebase64(String filebase64) {
            this.filebase64 = filebase64;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FileData)) {
                return false;
            }
            FileData other = (FileData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$filename = this.getFilename();
            String other$filename = other.getFilename();
            if (this$filename == null ? other$filename != null : !this$filename.equals(other$filename)) {
                return false;
            }
            String this$filetype = this.getFiletype();
            String other$filetype = other.getFiletype();
            if (this$filetype == null ? other$filetype != null : !this$filetype.equals(other$filetype)) {
                return false;
            }
            String this$filebase64 = this.getFilebase64();
            String other$filebase64 = other.getFilebase64();
            if (this$filebase64 == null ? other$filebase64 != null : !this$filebase64.equals(other$filebase64)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            return !(this$description == null ? other$description != null : !this$description.equals(other$description));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FileData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $filename = this.getFilename();
            result = result * 59 + ($filename == null ? 43 : $filename.hashCode());
            String $filetype = this.getFiletype();
            result = result * 59 + ($filetype == null ? 43 : $filetype.hashCode());
            String $filebase64 = this.getFilebase64();
            result = result * 59 + ($filebase64 == null ? 43 : $filebase64.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            return result;
        }

        public String toString() {
            return "BeiJingInJTLZServiceImpl.FileData(filename=" + this.getFilename() + ", filetype=" + this.getFiletype() + ", filebase64=" + this.getFilebase64() + ", description=" + this.getDescription() + ")";
        }
    }

    public static class OperatorData {
        private String account;
        private String name;
        private String idcardno;
        private String orgName;
        private String roleName;
        private String regionName;
        private String regionCode;

        public static OperatorData fixedOperatorData() {
            OperatorData operatorData = new OperatorData();
            operatorData.setAccount("003849");
            operatorData.setName("\u738b\u946b");
            operatorData.setIdcardno("110104198412242026");
            operatorData.setOrgName("\u5317\u4eac\u5e02\u6cbb\u5b89\u7ba1\u7406\u603b\u961f");
            operatorData.setRoleName("\u4e8c\u7ea7\u8b66\u957f");
            operatorData.setRegionName("\u897f\u57ce\u533a");
            operatorData.setRegionCode("110102");
            return operatorData;
        }

        public String getAccount() {
            return this.account;
        }

        public String getName() {
            return this.name;
        }

        public String getIdcardno() {
            return this.idcardno;
        }

        public String getOrgName() {
            return this.orgName;
        }

        public String getRoleName() {
            return this.roleName;
        }

        public String getRegionName() {
            return this.regionName;
        }

        public String getRegionCode() {
            return this.regionCode;
        }

        public void setAccount(String account) {
            this.account = account;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setIdcardno(String idcardno) {
            this.idcardno = idcardno;
        }

        public void setOrgName(String orgName) {
            this.orgName = orgName;
        }

        public void setRoleName(String roleName) {
            this.roleName = roleName;
        }

        public void setRegionName(String regionName) {
            this.regionName = regionName;
        }

        public void setRegionCode(String regionCode) {
            this.regionCode = regionCode;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OperatorData)) {
                return false;
            }
            OperatorData other = (OperatorData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$account = this.getAccount();
            String other$account = other.getAccount();
            if (this$account == null ? other$account != null : !this$account.equals(other$account)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$idcardno = this.getIdcardno();
            String other$idcardno = other.getIdcardno();
            if (this$idcardno == null ? other$idcardno != null : !this$idcardno.equals(other$idcardno)) {
                return false;
            }
            String this$orgName = this.getOrgName();
            String other$orgName = other.getOrgName();
            if (this$orgName == null ? other$orgName != null : !this$orgName.equals(other$orgName)) {
                return false;
            }
            String this$roleName = this.getRoleName();
            String other$roleName = other.getRoleName();
            if (this$roleName == null ? other$roleName != null : !this$roleName.equals(other$roleName)) {
                return false;
            }
            String this$regionName = this.getRegionName();
            String other$regionName = other.getRegionName();
            if (this$regionName == null ? other$regionName != null : !this$regionName.equals(other$regionName)) {
                return false;
            }
            String this$regionCode = this.getRegionCode();
            String other$regionCode = other.getRegionCode();
            return !(this$regionCode == null ? other$regionCode != null : !this$regionCode.equals(other$regionCode));
        }

        protected boolean canEqual(Object other) {
            return other instanceof OperatorData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $account = this.getAccount();
            result = result * 59 + ($account == null ? 43 : $account.hashCode());
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $idcardno = this.getIdcardno();
            result = result * 59 + ($idcardno == null ? 43 : $idcardno.hashCode());
            String $orgName = this.getOrgName();
            result = result * 59 + ($orgName == null ? 43 : $orgName.hashCode());
            String $roleName = this.getRoleName();
            result = result * 59 + ($roleName == null ? 43 : $roleName.hashCode());
            String $regionName = this.getRegionName();
            result = result * 59 + ($regionName == null ? 43 : $regionName.hashCode());
            String $regionCode = this.getRegionCode();
            result = result * 59 + ($regionCode == null ? 43 : $regionCode.hashCode());
            return result;
        }

        public String toString() {
            return "BeiJingInJTLZServiceImpl.OperatorData(account=" + this.getAccount() + ", name=" + this.getName() + ", idcardno=" + this.getIdcardno() + ", orgName=" + this.getOrgName() + ", roleName=" + this.getRoleName() + ", regionName=" + this.getRegionName() + ", regionCode=" + this.getRegionCode() + ")";
        }
    }

    public static class SignatureData {
        private String name;
        private String address;
        private String headphoto;
        private String idcardno;
        private String year;
        private String month;
        private String day;
        private String certificateno;
        private String certificatefrom;
        private String isSignature;
        private String fzDate;
        private String zYear;
        private String zMonth;
        private String zDay;
        private String signatureImg;
        private String unSignaturePDF;
        private String signaturePDF;

        public String getName() {
            return this.name;
        }

        public String getAddress() {
            return this.address;
        }

        public String getHeadphoto() {
            return this.headphoto;
        }

        public String getIdcardno() {
            return this.idcardno;
        }

        public String getYear() {
            return this.year;
        }

        public String getMonth() {
            return this.month;
        }

        public String getDay() {
            return this.day;
        }

        public String getCertificateno() {
            return this.certificateno;
        }

        public String getCertificatefrom() {
            return this.certificatefrom;
        }

        public String getIsSignature() {
            return this.isSignature;
        }

        public String getFzDate() {
            return this.fzDate;
        }

        public String getZYear() {
            return this.zYear;
        }

        public String getZMonth() {
            return this.zMonth;
        }

        public String getZDay() {
            return this.zDay;
        }

        public String getSignatureImg() {
            return this.signatureImg;
        }

        public String getUnSignaturePDF() {
            return this.unSignaturePDF;
        }

        public String getSignaturePDF() {
            return this.signaturePDF;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setAddress(String address) {
            this.address = address;
        }

        public void setHeadphoto(String headphoto) {
            this.headphoto = headphoto;
        }

        public void setIdcardno(String idcardno) {
            this.idcardno = idcardno;
        }

        public void setYear(String year) {
            this.year = year;
        }

        public void setMonth(String month) {
            this.month = month;
        }

        public void setDay(String day) {
            this.day = day;
        }

        public void setCertificateno(String certificateno) {
            this.certificateno = certificateno;
        }

        public void setCertificatefrom(String certificatefrom) {
            this.certificatefrom = certificatefrom;
        }

        public void setIsSignature(String isSignature) {
            this.isSignature = isSignature;
        }

        public void setFzDate(String fzDate) {
            this.fzDate = fzDate;
        }

        public void setZYear(String zYear) {
            this.zYear = zYear;
        }

        public void setZMonth(String zMonth) {
            this.zMonth = zMonth;
        }

        public void setZDay(String zDay) {
            this.zDay = zDay;
        }

        public void setSignatureImg(String signatureImg) {
            this.signatureImg = signatureImg;
        }

        public void setUnSignaturePDF(String unSignaturePDF) {
            this.unSignaturePDF = unSignaturePDF;
        }

        public void setSignaturePDF(String signaturePDF) {
            this.signaturePDF = signaturePDF;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SignatureData)) {
                return false;
            }
            SignatureData other = (SignatureData)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$address = this.getAddress();
            String other$address = other.getAddress();
            if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
                return false;
            }
            String this$headphoto = this.getHeadphoto();
            String other$headphoto = other.getHeadphoto();
            if (this$headphoto == null ? other$headphoto != null : !this$headphoto.equals(other$headphoto)) {
                return false;
            }
            String this$idcardno = this.getIdcardno();
            String other$idcardno = other.getIdcardno();
            if (this$idcardno == null ? other$idcardno != null : !this$idcardno.equals(other$idcardno)) {
                return false;
            }
            String this$year = this.getYear();
            String other$year = other.getYear();
            if (this$year == null ? other$year != null : !this$year.equals(other$year)) {
                return false;
            }
            String this$month = this.getMonth();
            String other$month = other.getMonth();
            if (this$month == null ? other$month != null : !this$month.equals(other$month)) {
                return false;
            }
            String this$day = this.getDay();
            String other$day = other.getDay();
            if (this$day == null ? other$day != null : !this$day.equals(other$day)) {
                return false;
            }
            String this$certificateno = this.getCertificateno();
            String other$certificateno = other.getCertificateno();
            if (this$certificateno == null ? other$certificateno != null : !this$certificateno.equals(other$certificateno)) {
                return false;
            }
            String this$certificatefrom = this.getCertificatefrom();
            String other$certificatefrom = other.getCertificatefrom();
            if (this$certificatefrom == null ? other$certificatefrom != null : !this$certificatefrom.equals(other$certificatefrom)) {
                return false;
            }
            String this$isSignature = this.getIsSignature();
            String other$isSignature = other.getIsSignature();
            if (this$isSignature == null ? other$isSignature != null : !this$isSignature.equals(other$isSignature)) {
                return false;
            }
            String this$fzDate = this.getFzDate();
            String other$fzDate = other.getFzDate();
            if (this$fzDate == null ? other$fzDate != null : !this$fzDate.equals(other$fzDate)) {
                return false;
            }
            String this$zYear = this.getZYear();
            String other$zYear = other.getZYear();
            if (this$zYear == null ? other$zYear != null : !this$zYear.equals(other$zYear)) {
                return false;
            }
            String this$zMonth = this.getZMonth();
            String other$zMonth = other.getZMonth();
            if (this$zMonth == null ? other$zMonth != null : !this$zMonth.equals(other$zMonth)) {
                return false;
            }
            String this$zDay = this.getZDay();
            String other$zDay = other.getZDay();
            if (this$zDay == null ? other$zDay != null : !this$zDay.equals(other$zDay)) {
                return false;
            }
            String this$signatureImg = this.getSignatureImg();
            String other$signatureImg = other.getSignatureImg();
            if (this$signatureImg == null ? other$signatureImg != null : !this$signatureImg.equals(other$signatureImg)) {
                return false;
            }
            String this$unSignaturePDF = this.getUnSignaturePDF();
            String other$unSignaturePDF = other.getUnSignaturePDF();
            if (this$unSignaturePDF == null ? other$unSignaturePDF != null : !this$unSignaturePDF.equals(other$unSignaturePDF)) {
                return false;
            }
            String this$signaturePDF = this.getSignaturePDF();
            String other$signaturePDF = other.getSignaturePDF();
            return !(this$signaturePDF == null ? other$signaturePDF != null : !this$signaturePDF.equals(other$signaturePDF));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SignatureData;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $address = this.getAddress();
            result = result * 59 + ($address == null ? 43 : $address.hashCode());
            String $headphoto = this.getHeadphoto();
            result = result * 59 + ($headphoto == null ? 43 : $headphoto.hashCode());
            String $idcardno = this.getIdcardno();
            result = result * 59 + ($idcardno == null ? 43 : $idcardno.hashCode());
            String $year = this.getYear();
            result = result * 59 + ($year == null ? 43 : $year.hashCode());
            String $month = this.getMonth();
            result = result * 59 + ($month == null ? 43 : $month.hashCode());
            String $day = this.getDay();
            result = result * 59 + ($day == null ? 43 : $day.hashCode());
            String $certificateno = this.getCertificateno();
            result = result * 59 + ($certificateno == null ? 43 : $certificateno.hashCode());
            String $certificatefrom = this.getCertificatefrom();
            result = result * 59 + ($certificatefrom == null ? 43 : $certificatefrom.hashCode());
            String $isSignature = this.getIsSignature();
            result = result * 59 + ($isSignature == null ? 43 : $isSignature.hashCode());
            String $fzDate = this.getFzDate();
            result = result * 59 + ($fzDate == null ? 43 : $fzDate.hashCode());
            String $zYear = this.getZYear();
            result = result * 59 + ($zYear == null ? 43 : $zYear.hashCode());
            String $zMonth = this.getZMonth();
            result = result * 59 + ($zMonth == null ? 43 : $zMonth.hashCode());
            String $zDay = this.getZDay();
            result = result * 59 + ($zDay == null ? 43 : $zDay.hashCode());
            String $signatureImg = this.getSignatureImg();
            result = result * 59 + ($signatureImg == null ? 43 : $signatureImg.hashCode());
            String $unSignaturePDF = this.getUnSignaturePDF();
            result = result * 59 + ($unSignaturePDF == null ? 43 : $unSignaturePDF.hashCode());
            String $signaturePDF = this.getSignaturePDF();
            result = result * 59 + ($signaturePDF == null ? 43 : $signaturePDF.hashCode());
            return result;
        }

        public String toString() {
            return "BeiJingInJTLZServiceImpl.SignatureData(name=" + this.getName() + ", address=" + this.getAddress() + ", headphoto=" + this.getHeadphoto() + ", idcardno=" + this.getIdcardno() + ", year=" + this.getYear() + ", month=" + this.getMonth() + ", day=" + this.getDay() + ", certificateno=" + this.getCertificateno() + ", certificatefrom=" + this.getCertificatefrom() + ", isSignature=" + this.getIsSignature() + ", fzDate=" + this.getFzDate() + ", zYear=" + this.getZYear() + ", zMonth=" + this.getZMonth() + ", zDay=" + this.getZDay() + ", signatureImg=" + this.getSignatureImg() + ", unSignaturePDF=" + this.getUnSignaturePDF() + ", signaturePDF=" + this.getSignaturePDF() + ")";
        }
    }
}

