package com.bcxin.backend.tasks;

import com.bcxin.backend.domain.signature.service.QzSignatureStrategy;
import com.bcxin.backend.domain.signature.service.QzSignatureStrategyFactory;
import com.bcxin.backend.domain.signature.service.SignatureToPDFService;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

/**
 * 生成pdf文件到temp目录
 */
@Component
@ConditionalOnProperty(prefix = "myapps.signature",name = "enable",havingValue = "true")
public class SignatureJobTask extends TaskAbstract{


    @Value("${myapps.signature.serverKey}")
    String serverKey;

    @Override
    protected void runCore() {
        QzSignatureStrategy qzSignatureStrategy = QzSignatureStrategyFactory.getBYServerKey(serverKey);
        qzSignatureStrategy.cerPDF();
    }

    @Override
    public String getTaskName() {
        return "execute.signature.pdf.job.create_pdf";
    }

}
