package com.bcxin.backend.tasks;

import com.bcxin.backend.domain.signature.service.QzSignatureStrategy;
import com.bcxin.backend.domain.signature.service.QzSignatureStrategyFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

/**
 * 扫描签章表中状态（status）为3（已生成pdf待签章的数据）且当前时间大于上一次更新时间（last_processed_time）5小时以上,将其状态改为0
 */
@Component
@ConditionalOnProperty(prefix = "myapps.signature",name = "enable",havingValue = "true")
public class SignatureJobChangeStatusTask extends TaskAbstract{

    @Value("${myapps.signature.serverKey}")
    String serverKey;

    @Override
    protected void runCore() {
        QzSignatureStrategy qzSignatureStrategy = QzSignatureStrategyFactory.getBYServerKey(serverKey);
        qzSignatureStrategy.changeStatus();
    }

    @Override
    public String getTaskName() {
        return "execute.signature.pdf.job.change";
    }

}
