package com.bcxin.backend.tasks;

import cn.hutool.core.bean.BeanUtil;
import com.alibaba.fastjson.JSONArray;
import com.bcxin.backend.configs.SmsConfig;
import com.bcxin.backend.domain.models.MessageDto;
import com.bcxin.backend.domain.models.MessageEntity;
import com.bcxin.backend.domain.models.NoticeDto;
import com.bcxin.backend.domain.repositories.MessageDtoRepository;
import com.bcxin.backend.domain.repositories.MessageRepository;
import com.bcxin.backend.domain.repositories.NoticeRepository;
import com.bcxin.backend.dto.HuaWeiSmsContent;
import com.bcxin.backend.utils.MessageUtil;
import com.bcxin.saas.core.enums.MessageType;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

@Component
public class MessageSendJobTask extends TaskAbstract {

    private final MessageDtoRepository messageDtoRepository;

    private final MessageRepository messageRepository;

    private final NoticeRepository noticeRepository;

    public MessageSendJobTask( MessageDtoRepository messageDtoRepository,MessageRepository messageRepository,NoticeRepository noticeRepository) {
        this.messageDtoRepository = messageDtoRepository;
        this.messageRepository = messageRepository;
        this.noticeRepository = noticeRepository;
    }

    @Override
    protected void runCore() {
        Collection<MessageDto> messageDtos = null;
        Page<MessageDto> pagedMessageEntities =
                this.messageDtoRepository.getPendings(Pageable.ofSize(100));
        messageDtos = pagedMessageEntities.getContent();

        log(String.format("共有%s个消息待处理;", messageDtos.size()));

        if(messageDtos.size() == 0){
            return;
        }

        MessageEntity messageEntity = null;
        List<MessageEntity> messageEntityList = new ArrayList<>();

        List<NoticeDto> noticeList = new ArrayList<>();
        for (MessageDto messageDto : messageDtos) {
            messageEntity = new MessageEntity();
            BeanUtil.copyProperties(messageDto,messageEntity);
            messageEntityList.add(messageEntity);
            try {
                if(MessageType.Sms.equals(messageDto.getMessageType())){
                    //发送短信
                    boolean result = true;
                    if(SmsConfig.isSendSwitch()) {
                        List<String> params = new ArrayList<>();
                        params.add(messageDto.getContent());
                        HuaWeiSmsContent huaWeiSmsContent = new HuaWeiSmsContent();
                        huaWeiSmsContent.setMobile(messageDto.getReceiver());
                        huaWeiSmsContent.setParams(JSONArray.toJSONString(params));
                        huaWeiSmsContent.setSmsCode(SmsConfig.getCode());
                        result = MessageUtil.sendHuaWeiSMS(huaWeiSmsContent);
                    }
                    messageEntity.makeStatus(result);
                    continue;
                }
                if(MessageType.Message.equals(messageDto.getMessageType())){
                    //站内信
                    NoticeDto notice = new NoticeDto(messageDto.getId(),
                            messageDto.getContent(),
                            messageDto.getReceiver(),
                            messageDto.getOrganizationId());
                    noticeList.add(notice);
                    messageEntity.makeStatus(true);
                }
            } catch (Exception ex) {
                ex.printStackTrace();
                messageEntity.makeStatus(false);
                logger.error(String.format("id=%s; msg=%s", messageDto.getId(), ex.toString()), ex);
            }
        }

        if(noticeList.size() > 0) {
            noticeRepository.saveAll(noticeList);
        }

        this.messageRepository.saveAll(messageEntityList);
    }

    @Override
    public String getTaskName() {
        return "message.send";
    }


}
