package com.bcxin.backend.tasks;

import com.bcxin.backend.domain.syncs.services.impls.GetAppTaskJobServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;


@Component
public class ExecuteCleanAppJobTask extends TaskAbstract{


    @Autowired
    private final GetAppTaskJobServiceImpl getAppTaskJobService;

    public ExecuteCleanAppJobTask(GetAppTaskJobServiceImpl getAppTaskJobService) {

        this.getAppTaskJobService = getAppTaskJobService;
    }


    @Override
    protected void runCore() throws Exception {
        getAppTaskJobService.cleanAppTaskIdsCache();
    }

    @Override
    public String getTaskName() {
        return "execute.clean.app.job";
    }
}
