package com.bcxin.backend.documentSignatrures.impls;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.backend.documentSignatrures.SignatureConfigProperty;
import com.bcxin.backend.domain.repositories.SignatureQueuesDocumentRepository;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Component;

@Component
@Qualifier("beijing")
public class DocumentSignatureProvider_Beijing extends DocumentSignatureProviderAbstract{
    private static final Logger logger = LoggerFactory.getLogger(DocumentSignatureProvider_Beijing.class);

    protected DocumentSignatureProvider_Beijing(SignatureConfigProperty configProperty,
                                                SignatureQueuesDocumentRepository signatureQueuesDocumentRepository,
                                                @Qualifier("primaryJdbcTemplate") JdbcTemplate jdbcTemplate) {
        super(configProperty, signatureQueuesDocumentRepository, jdbcTemplate);
    }

    @Override
    protected Logger getLogger() {
        return logger;
    }

    /**
     * <b> 激活电子印章签验接口服务器完成签章 </b>
     * @author ZXF
     * @create 2022/11/21 0021 10:44
     * @version
     * @注意事项 </b>
     */
    @Override
    protected boolean activateXMPDocumentQuicklyExCGI(String stamp_xy) {
        String cgiApi = configProperty.getCgiApi();

        StringBuilder sb = new StringBuilder();
        try {
            String[] arrXY = stamp_xy.split(",");
            JSONObject json = new JSONObject();
            json.put("service", "wss://127.0.0.1:8800");
            json.put("sn", "2171101001014060");//保安管理专用章 UKey编码
            json.put("pin", "88888888");
            json.put("in", "/data/share/in/document");
            json.put("out", "/data/share/out/document");
            JSONArray arr = new JSONArray();
            JSONObject pos = new JSONObject();
            pos.put("centerX", Integer.parseInt(arrXY[1]));
            pos.put("centerY", Integer.parseInt(arrXY[2]));
            pos.put("page", Integer.parseInt(arrXY[0]));
            arr.add(pos);
            json.put("signOnPos", arr);
            String ret = HttpUtil.post(cgiApi, json.toJSONString());
            sb.append(String.format("result=%s",ret));
            if (StringUtils.isEmpty(ret)) {
                return false;
            }
            JSONObject result = JSON.parseObject(ret.replace("#", ""));
            if ("1".equals(String.valueOf(result.get("code")))) {
                return true;
            }
            return false;
        } catch (Exception e) {
            getLogger().error("执行 activateXMPDocumentQuicklyExCGI: {} 发生异常", stamp_xy, e);
        }
        finally {
            getLogger().error("执行 activateXMPDocumentQuicklyExCGI跟踪信息:{}", sb);
        }

        return false;
    }
}
