package com.bcxin.risk.user.dto.data;

import com.bcxin.risk.hibernateplus.entity.page.Page;
import lombok.Data;

import java.util.Map;

@Data
public class UserRoleDataDto {

    private String user_id; // 用户ID

    private String userName; // 用户名

    private String realName; // 真实姓名

    private String active; //0或者1

    private String 	email; //邮箱

    private String password;  //密码

    private String 	phone; //手机

    private String userType; // 用户类型

    private String orgType; // 机构类型

    private String createOn; // 记录生成时间

    private String xzbz; // 选择标志

    private String role_id; // 角色ID

    private String roleName; // 角色名

    private String roleCode; // 角色代码

    private String roleDesc; // 角色描述

    private String signature; //电子签名

    /**
     * 专家审核状态
     */
    private String checkStatus;

    private String total;

    private Page page;

    public UserRoleDataDto(Map<String,Object> map){
        this.user_id = safeTransfor(map.get("user_id"));
        this.userName = safeTransfor(map.get("userName"));
        this.realName = safeTransfor(map.get("realName"));
        this.active = safeTransfor(map.get("active"));
        this.email = safeTransfor(map.get("email"));
        this.password = safeTransfor(map.get("password"));
        this.phone = safeTransfor(map.get("phone"));
        this.userType = safeTransfor(map.get("userType"));
        this.orgType = safeTransfor(map.get("orgType"));
        this.createOn = safeTransfor(map.get("createOn"));
        this.xzbz = safeTransfor(map.get("xzbz"));
        this.role_id = safeTransfor(map.get("role_id"));
        this.roleName = safeTransfor(map.get("roleName"));
        this.roleCode = safeTransfor(map.get("roleCode"));
        this.signature = safeTransfor(map.get("signature"));
        this.checkStatus=safeTransfor(map.get("checkStatus"));
    }

    private String safeTransfor(Object obj){
        if ( obj == null ) {
            return "";
        }
        return obj.toString();
    }
}

