package com.bcxin.risk.user.dto.data;

import com.bcxin.risk.hibernateplus.entity.page.Page;
import lombok.Data;
import org.apache.commons.lang3.ObjectUtils;

import java.util.Map;
import java.util.Objects;

/**
 * 专家用户传输对象
 * @author Administrator
 * @date 2017/07/26 0026
 */
@Data
public class ExpertUserDataDto {

    /**
     * 用户id
     */
    private String oid;

    /**
     * 真实名称
     */
    private String realName;

    /**
     * 用户名称
     */
    private String userName ;

    /**
     * 手机号
     */
    private String  phone;

    /**
     * 来源
     */
    private String source ;

    private String createOn ;

    /**
     * 可用状态
     */
    private String active;

    private Page page;

    /**
     * 机构名称
     */
    private String orgName;

    /**
     * 专家分类
     */
    private String expertCategory;

    /**
     * 专家等级
     */
    private String level;

    private String expertSource;
    private String expertSourceName;

    /**
     * 报价
     */
    private String taskQuote;

    /**
     * 任务类型
     */
    private String expertTaskType;

    private String serviceOrg_id;

    /**
     * 用户类型
     */
    private String userType;


    /*勘查专家类型*/
    private String ktType;

    /**
     * 用户类型名称
     */
    private String userTypeName;

    /*是否可以修改勘查专家类型*/
    private String isUpdateKtType;

    /**
     * 擅长专业
     */
    private String professional;

    /**
     * 擅长专业名称
     */
    private String professionalName;

    /**
     * 工作地点
     */
    private String jobLiveAddr;

    public  ExpertUserDataDto(Map<String,Object> map){
        this.oid = safeTransfor(map.get("oid"));
        this.realName = safeTransfor(map.get("realName"));
        this.userName = safeTransfor(map.get("userName"));
        this.phone = safeTransfor(map.get("phone"));
        this.source = safeTransfor(map.get("source"));
        this.createOn = safeTransfor(map.get("createOn"));
        this.active = safeTransfor(map.get("active"));
        this.expertCategory = safeTransfor(map.get("expertCategory"));
        this.level= safeTransfor(map.get("level"));
        this.taskQuote=safeTransfor(map.get("taskQuote"));
        this.expertSource= safeTransfor(map.get("expertSource"));
        this.orgName = safeTransfor(map.get("orgName"));
        this.expertTaskType = safeTransfor(map.get("expertTaskType"));
        this.serviceOrg_id = safeTransfor(map.get("serviceOrg_id"));
        this.userType = safeTransfor(map.get("userType"));
        this.ktType = safeTransfor(map.get("ktType"));
        this.isUpdateKtType = safeTransfor(map.get("isUpdateKtType"));
        this.userTypeName=safeTransfor(map.get("userTypeName"));
        this.professional = safeTransfor(map.get("professional"));
        this.professionalName= safeTransfor(map.get("professionalName"));
        if(map.get("jobLiveAddr")!=null){
            String [] addr=map.get("jobLiveAddr").toString().split("/");
            if(addr.length>1) {
                this.jobLiveAddr = addr[1];
            }else{
                this.jobLiveAddr=map.get("jobLiveAddr").toString();
            }
        }else{
            this.jobLiveAddr="";
        }

    }

    private String safeTransfor(Object obj){
        if ( obj == null ) {
            return "";
        }
        return obj.toString();
    }
}
