package com.bcxin.risk.user.domain;

import com.bcxin.risk.base.domain.BaseBean;
import com.bcxin.risk.org.domain.Org;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import java.util.Date;

@Entity
@Table(name = "RISK_SE_USER")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class User extends BaseBean {

	private static final long serialVersionUID = 1L;

	private String userName;

	/**
	 * 姓名
	 */
	private String realName;

	private String password;

	private String 	email; //邮箱

	private String 	phone; //手机

	private String 	companyPhone; //企业联系方式

	private String orgAdmin;//是否是机构管理员；1代表是，0代表不是

	private String userType;//用户类型（承办，服务机构，专家，管理等）

	private String ktType;//专家类型（14 撰写专家 ，16 勘查人员，17 专家现场勘查，23 专家远程勘查 ，24 专家远程咨询）

	private String active ; //是否有效 0:无效，1:有效

	/** 找回密码 **/
	private String validateCode; //密钥
	
	@Temporal(TemporalType.TIMESTAMP)
	private Date overdueTime;  //过期时间

	@ManyToOne(targetEntity = Org.class, fetch = FetchType.EAGER)
	@JoinColumn(name = "org_id")
	private Org org; //所属机构
	/**
	 * 注册人ip
	 */
	private String ipAddress;

	/**
	 * 用户登陆后获得菜单
	 */
	@Transient
	private String allowMenus;

	@Transient
	private String carryInfo; //携带的信息，包括密码可反译之类的，方便用两个系统来回跳转使用

	private Long area_id;  // 区域ID

	private Long city_id;  // 城市ID

	private Long province_id;  // 省份ID

	private String isSync ; // 业务支撑同步标志 0:未同步，1:同步

	private String ywzcId ; // 业务支撑ID

	private String channel;//活动申请的渠道（sb_sn.dh.pss360.cn,代表申报子系统陕西环境）

	private String signature;//电子签名

	/**
	 * saas企业id
	 */
	private String comId;

	/**
	 * saas人员id
	 */
	private String perId;

	/**
	 * 账户来源：SB，PSS，SASS
	 */
	private String source;

	/**
	 * e签宝id
	 */
	private String esignId;


}
