package com.bcxin.risk.surveytk.enums;

/**
 * @author hzp
 * 任务接收状态枚举
 */
public enum AcceptStatusEnum {

    UN_ACCEPT("0","未接受"),
    ACCEPT("1","已接受"),
    TRANSFER("2","申请转交");

    private String key;
    private String alias;

    AcceptStatusEnum(String key,String alias){
        this.key=key;
        this.alias=alias;
    }

    public String getKey(){
        return this.key;
    }

    public String getAlias(){
        return this.alias;
    }

    public static String getAlias(String key){
        for(AcceptStatusEnum e : AcceptStatusEnum.values()){
            if(e.getKey().equals(key)){
                return e.getAlias();
            }
        }
        return "";
    }
}
