package com.bcxin.risk.surveytk.domain.dto;

import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.report.enums.SurveyStep;
import lombok.Data;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * @author hzp
 * 踏勘阶段详情
 */
@Data
public class SurveyStepDataDto implements Serializable {

    /**
     * 踏勘反馈id
     */
    private String feedBackId;

    /**
     * 踏勘计划id
     */
    private String planId;

    /**
     * 踏勘任务id
     */
    private String surveyTaskId;

    /**
     * 场馆id
     */
    private String venueId;

    /**
     * 踏勘问卷id
     */
    private String questionnaireId;

    /**
     * 踏勘阶段
     */
    private String surveyStep;
    /**
     * 踏勘阶段名称
     */
    private String surveyStepName;

    /**
     * 踏勘专家
     */
    private String tkExpert;

    /**
     * 计划状态
     */
    private String planStatus;

    /**
     * 踏勘报告
     */
    private String surveyReport;

    /**
     * 踏勘开始时间
     */
    private String beginTime;

    /**
     * 踏勘结束时间
     */
    private String endTime;

    /**
     * 踏勘场馆
     */
    private String venueName;

    /**
     * 整改意见列表
     */
    private List<SurveyStepReformDataDto> reformList;

    public SurveyStepDataDto(){

    }
    public SurveyStepDataDto(Map<String,Object> map){
        this.tkExpert=safeTransFor(map.get("tkExpert"));
        if(StringUtil.isEmpty(this.tkExpert)){
            this.tkExpert="--";
        }
        this.feedBackId=safeTransFor(map.get("feedBackId"));
        this.planId=safeTransFor(map.get("planId"));
        this.surveyTaskId=safeTransFor(map.get("surveyTaskId"));
        this.venueId=safeTransFor(map.get("venueId"));
        this.questionnaireId=safeTransFor(map.get("questionnaireId"));
        this.surveyStep=safeTransFor(map.get("surveyStep"));
        this.surveyStepName=SurveyStep.convertAlias(safeTransFor(map.get("surveyStep")));
        this.planStatus=safeTransFor(map.get("planStatus"));
        this.surveyReport=safeTransFor(map.get("surveyReport"));
        this.beginTime=safeTransFor(map.get("beginTime"));
        this.endTime=safeTransFor(map.get("endTime"));
        this.venueName=safeTransFor(map.get("venueName"));
    }

    private String safeTransFor(Object obj){
        if ( obj == null ) {
            return "";
        }
        return obj.toString();
    }
}
