package com.bcxin.risk.survey.domain;

import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;

import lombok.Data;

import com.bcxin.risk.base.domain.BaseBean;
import com.bcxin.risk.report.enums.QuestionType;
import com.bcxin.risk.report.enums.SurveyStep;

/**
 * 勘查项目//数据来源cms中的dede_addon32表(开放问题)、dede_addon41(固定问题)
 * @author BCXIN
 *
 */
@Entity
@Table(name = "RISK_SurveyProject")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
public class SurveyProject extends BaseBean {

	private static final long	serialVersionUID	= 1L;
	
	@Enumerated(EnumType.STRING)
	private SurveyStep surveyStep;//勘察阶段

	private String question;//勘查题目

	private String answerTip;//结果提示
	
	@Enumerated(EnumType.STRING)
	private QuestionType questionType;//问题类型
	
	private String aid;//cms中对应的问题ID
	
	private long sort = 0;//排序编号

}
