package com.bcxin.risk.survey.domain;

import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import com.bcxin.risk.user.domain.User;
import lombok.Data;

import com.bcxin.risk.base.domain.BaseBean;
import com.bcxin.risk.report.enums.AssignStatus;
import com.bcxin.risk.report.enums.AssignType;
import com.bcxin.risk.report.enums.SurveyStep;

/**
 * 勘查协助（任务转交及申请专家）
 * @author Administrator
 *
 */
@Entity
@Table(name = "RISK_SurveyAssist")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
public class SurveyAssist extends BaseBean {

	private static final long serialVersionUID = 1L;
	
	//任务编号
	@ManyToOne(targetEntity = SurveyTask.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "taskId")
	private SurveyTask surveyTask = new SurveyTask();
	
	// 勘察员工号
	@ManyToOne(targetEntity = User.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "userId")
	private User user = new User();
	
	//接收者
	@ManyToOne(targetEntity = User.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "accepterId")
	private User accepter = new User();
	
	@Enumerated(EnumType.STRING)
	private SurveyStep surveyStep;//查勘阶段
	
	private String experts;//申请的专家
	
	private String reason;//申请原因

	@Enumerated(EnumType.STRING)
	private AssignType assignType;//任务类型
	
//	@Enumerated(EnumType.STRING)
//	private AssignStatus assignStatus;//分配状态

	private String assignStatus;//分配状态

}
