package com.bcxin.risk.report.material.domain;

import com.bcxin.risk.activity.Activity;
import com.bcxin.risk.base.domain.BaseBean;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;


/**
 * <b>Function </b> 活动材料上传表单菜单，对应的菜单
 * 
 * @author LuoPeng
 * @date 2017年1月4日 下午9:29:32
 * @注意事项 </b>
 * <b>
 */
@Entity
@Table(name = "RISK_MaterialFormMenu")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class MaterialFormMenu extends BaseBean {

	private static final long serialVersionUID = -2963605545476898489L;

	/**  对应的活动*/
	@ManyToOne(targetEntity = Activity.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "activity_id")
	private Activity activity;
	
	/**  排序*/
	private int seq;

	/** 菜单代码**/
	private String menuCode;

	/**  菜单名称*/
	private String menuName;
	
	/**  是否为必录项*/
	private String required;
	
	/**  菜单项是否录入完成 **/
	private String completed;

	/**  菜单项被修改，在活动审批打回阶段 **/
	private String modify;

	/**
	 * 根据多选的服务机构，菜单项需要录入多个主体
	 */
	private String multi;
	
	@OneToOne(targetEntity = MaterialFormClass.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "class_id")
	private MaterialFormClass formClass;


}
