package com.bcxin.risk.report.material.domain;

import com.bcxin.risk.base.domain.BaseBean;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;

/**
 * 活动材料上传表单分类，七大模块分类，与材料模板关联
 * @author Ethan
 */
@Entity
@Table(name = "RISK_MaterialFormClass")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class MaterialFormClass extends BaseBean {

	private static final long serialVersionUID = -6574994074983443533L;
	
	private int seq;

	/**  七大分类模块代码*/
	private String classCode;
	
	/**  七大分类模块名称*/
	private String className;
	
	@Transient
	private int progress;

}
