package com.bcxin.risk.report.enums.draft;

/**
 * 审核状态
 * @author luopeng
 *
 */
public enum VerifyStatus {
	
	INIT{public String getValue(){return "0";} public String getName(){return "待提交";} public String getEname(){return "INIT";}},
	
	PENDING{public String getValue(){return "1";} public String getName(){return "待审核";}public String getEname(){return "PENDING";}},
	
	NOPASS {public String getValue(){return "2";} public String getName(){return "审核不通过";}public String getEname(){return "NOPASS";}},
	
	PASS {public String getValue(){return "3";} public String getName(){return "审核通过";}public String getEname(){return "PASS";}},
	
	READY {public String getValue(){return "4";} public String getName(){return "已修改待提交";}public String getEname(){return "READY";}}; 

    public abstract String getValue();
    
    public abstract String getName();
    
    public abstract String getEname();
    
    public static VerifyStatus convert_value(String value){
    	if ( "0".equals(value) ) {
    		return VerifyStatus.INIT;
    	} else if ( "1".equals(value) ) {
    		return VerifyStatus.PENDING;
    	} else if ("2".equals(value)) {
    		return VerifyStatus.NOPASS;
    	} else if ("3".equals(value)) {
    		return VerifyStatus.PASS;
    	} else if ("4".equals(value)) {
    		return VerifyStatus.READY;
    	}
    	return null;
    }
 
}
