package com.bcxin.risk.report.enums;

public enum SurveySubType {
	
	ENTRANCE {public String getValue(){return "1";} public String getName(){return "出入口";}}, 

	EMERGENCY {public String getValue(){return "2";} public String getName(){return "紧急疏散口";}},
	
	STOREROOM{public String getValue(){return "3";} public String getName(){return "储藏间";}};
	

    public abstract String getValue();
    
    public abstract String getName();
    
    public static SurveySubType convert(String value){
    	if ( "ENTRANCE".equals(value) ) {
    		return SurveySubType.ENTRANCE;
    	} else if ("EMERGENCY".equals(value)) {
    		return SurveySubType.EMERGENCY;
    	} else if ("STOREROOM".equals(value)) {
    		return SurveySubType.STOREROOM;
    	} 
    	return null;
    }
    
    public static SurveySubType convertValue(String value){
      	 if("1".equals(value)){return SurveySubType.ENTRANCE;}
	   	 else if("2".equals(value)){return SurveySubType.EMERGENCY;}
	   	 else if("3".equals(value)){return SurveySubType.STOREROOM;}
	   	 else{return null;}
	}
}
