package com.bcxin.risk.report.enums;

import java.util.ArrayList;
import java.util.List;

public enum OutDoorType {

	LOW{public String getValue(){return "0";} public String getName(){return "如学校体育场、校内广场";}},
	
	LOG_MIDDLE{public String getValue(){return "1";} public String getName(){return "如公园、文化广场";}},
	
	MIDDLE{public String getValue(){return "2";} public String getName(){return "商业区广场";}},
	
	HIGH{public String getValue(){return "3";} public String getName(){return "如海边沙滩、山地、水上、马拉松等";}},
	
	OHTER{public String getValue(){return "4";} public String getName(){return "其他";}};
	
	//政策法规
	
	
	
	
	public abstract String getValue();
    
    public abstract String getName();
    
    
    public static OutDoorType convert_name(String name){
    	if ( "LOW".equals(name) ) {
    		return OutDoorType.LOW;
    	} else if ("LOG_MIDDLE".equals(name)) {
    		return OutDoorType.LOG_MIDDLE;
    	} else if ("MIDDLE".equals(name)) {
    		return OutDoorType.MIDDLE;
    	} else if ("HIGH".equals(name)) {
    		return OutDoorType.HIGH;
    	} 
    	return OutDoorType.OHTER;
    }
    
  
    public static List<OutDoorType> all(){
    	List<OutDoorType> source = new ArrayList<OutDoorType>();
    	source.add(LOW);
    	source.add(LOG_MIDDLE);
    	source.add(MIDDLE);
    	source.add(HIGH);
    	source.add(OHTER);
    	return source;
    }
	
}
