package com.bcxin.risk.report.enums;

import java.util.ArrayList;
import java.util.List;

public enum LocalType {
	
	/** 电力系统*/
	ELECTRIC {public String getValue(){return "0";} public String getName(){return "电力系统";}}, 
	/** 出入口*/
	PASSAGEWAY{public String getValue(){return "1";} public String getName(){return "出入口";}},
	/** 缓冲区*/
	BUFFER{public String getValue(){return "2";} public String getName(){return "缓冲区";}},
	/** 应急通道*/
	ESCAPETRUCK{public String getValue(){return "3";} public String getName(){return "应急通道";}},
	/** 防暴栏*/
	RIOTCOLUMN{public String getValue(){return "4";} public String getName(){return "防暴栏";}},
	/** 座椅布置*/
	SEAT {public String getValue(){return "5";} public String getName(){return "座椅布置";}},
	/** 舞台搭建*/
	STAGE {public String getValue(){return "6";} public String getName(){return "舞台搭建";}},
	/** 周边交通*/
	TRAFFIC{public String getValue(){return "7";} public String getName(){return "周边交通";}},
	/** 消防*/
	FIRECONTROL{public String getValue(){return "8";} public String getName(){return "消防";}},
	/** 灯光照明*/
	LIGHTING{public String getValue(){return "9";} public String getName(){return "灯光照明";}},
	/** 停车场*/
	PARKINGSPACE{public String getValue(){return "10";} public String getName(){return "停车场";}},
	/** 通风*/
	AIRVENT{public String getValue(){return "11";} public String getName(){return "通风";}},
	/** 其他 */
	OTHER{public String getValue(){return "20";} public String getName(){return "其他";}};


    public abstract String getValue();
    
    public abstract String getName();
    
    public static LocalType convert(String value){
    	if ( "ELECTRIC".equals(value) ) {
    		return LocalType.ELECTRIC;
    	} else if ("PASSAGEWAY".equals(value)) {
    		return LocalType.PASSAGEWAY;
    	} else if ("BUFFER".equals(value)) {
    		return LocalType.BUFFER;
    	} else if ("ESCAPETRUCK".equals(value)) {
    		return LocalType.ESCAPETRUCK;
    	} else if ("RIOTCOLUMN".equals(value)) {
    		return LocalType.RIOTCOLUMN;
    	} else if ("SEAT".equals(value)) {
    		return LocalType.SEAT;
    	} else if ("STAGE".equals(value)) {
    		return LocalType.STAGE;
    	} else if ("TRAFFIC".equals(value)) {
    		return LocalType.TRAFFIC;
    	} else if ("FIRECONTROL".equals(value)) {
    		return LocalType.FIRECONTROL;
    	} else if ("LIGHTING".equals(value)) {
    		return LocalType.LIGHTING;
    	} else if ("PARKINGSPACE".equals(value)) {
    		return LocalType.PARKINGSPACE;
    	} else if ("AIRVENT".equals(value)) {
    		return LocalType.AIRVENT;
    	} else if ("OTHER".equals(value)) {
    		return LocalType.OTHER;
    	} 
    	return LocalType.OTHER;
    }
    
    public static LocalType convertValue(String value){
   	 if("0".equals(value)){return LocalType.ELECTRIC;}
	 else if("1".equals(value)){return LocalType.PASSAGEWAY;}
	 else if("2".equals(value)){return LocalType.BUFFER;}
	 else if("3".equals(value)){return LocalType.ESCAPETRUCK;}
	 else if("4".equals(value)){return LocalType.RIOTCOLUMN;}
	 else if("5".equals(value)){return LocalType.SEAT;}
	 else if("6".equals(value)){return LocalType.STAGE;}
	 else if("7".equals(value)){return LocalType.TRAFFIC;}
	 else if("8".equals(value)){return LocalType.FIRECONTROL;}
	 else if("9".equals(value)){return LocalType.LIGHTING;}
	 else if("10".equals(value)){return LocalType.PARKINGSPACE;}
	 else if("11".equals(value)){return LocalType.AIRVENT;}
	 else if("20".equals(value)){return LocalType.OTHER;}
	 else{return LocalType.OTHER;}
   }
    
    public static List<LocalType> list(){
    	List<LocalType> localTypes = new ArrayList<LocalType>();
    	localTypes.add(LocalType.ELECTRIC);
    	localTypes.add(LocalType.PASSAGEWAY);
    	localTypes.add(LocalType.BUFFER);
    	localTypes.add(LocalType.ESCAPETRUCK);
    	localTypes.add(LocalType.RIOTCOLUMN);
    	localTypes.add(LocalType.SEAT);
    	localTypes.add(LocalType.STAGE);
    	localTypes.add(LocalType.TRAFFIC);
    	localTypes.add(LocalType.FIRECONTROL);
    	localTypes.add(LocalType.LIGHTING);
    	localTypes.add(LocalType.PARKINGSPACE);
    	localTypes.add(LocalType.AIRVENT);
    	localTypes.add(LocalType.OTHER);
    	return localTypes;
    }
}
