package com.bcxin.risk.report.enums;

import java.util.ArrayList;
import java.util.List;

public enum CharacteristicType {

	//安保公司推荐
	SECURITYCOMPANY{
		public String getValue(){return "0";}
		public String getName(){return "安保公司";}
	},	
	//安检门供应商推荐
	SECURITYDOOR{
		public String getValue(){return "1";}
		public String getName(){return "安检门供应商";}
	},
	//舞台搭建方推荐
	STAGESTRUCTURES{
		public String getValue(){return "2";}
		public String getName(){return "舞台搭建方";}
	},
	//展会搭建方推荐
	EXHIBITIONBUILDING{
		public String getValue(){return "3";}
		public String getName(){return "展会搭建方";}
	};
	
	public abstract String getValue();
	public abstract String getName();
	
	public static CharacteristicType convert(String value){
    	if ( "SECURITYCOMPANY".equals(value) ) {
    		return CharacteristicType.SECURITYCOMPANY;
    	} else if ("SECURITYDOOR".equals(value)) {
    		return CharacteristicType.SECURITYDOOR;
    	}else if ("STAGESTRUCTURES".equals(value)) {
    		return CharacteristicType.STAGESTRUCTURES;
    	}else if ("EXHIBITIONBUILDING".equals(value)) {
    		return CharacteristicType.EXHIBITIONBUILDING;
    	}
    	return null;
    }
    
    public static CharacteristicType convertValue(String value){
    	if ( "0"==value ) {
    		return CharacteristicType.SECURITYCOMPANY;
    	}else if ( "1"==value ) {
    		return CharacteristicType.SECURITYDOOR;
    	} else if ("2"==value ) {
    		return CharacteristicType.STAGESTRUCTURES;
    	}else if ("3"==value ) {
    		return CharacteristicType.EXHIBITIONBUILDING;
    	}
    	return null;
    }
    
    public static List<CharacteristicType> list(){
    	List<CharacteristicType> list = new ArrayList<CharacteristicType>();
    	//list.add(City.GUOWUYUAN);
      	list.add(CharacteristicType.SECURITYCOMPANY);
      	list.add(CharacteristicType.SECURITYDOOR);
      	list.add(CharacteristicType.STAGESTRUCTURES);
      	list.add(CharacteristicType.EXHIBITIONBUILDING);
      	return list;
    }
}
