package com.bcxin.risk.report.enums;

import java.util.ArrayList;
import java.util.List;

public enum ActivityVideoType {
	
	/** 	体育比赛活动*/
	SPORT {public String getValue(){return "0";} public String getName(){return "体育比赛活动";}}, 
	/** 	文艺演出活动*/
	LITERATURE{public String getValue(){return "1";} public String getName(){return "文艺演出活动";}},
	/** 	展览，展销等活动*/
    EXHIBITION{public String getValue(){return "2";} public String getName(){return "展览，展销等活动";}};


    public abstract String getValue();
    
    public abstract String getName();
    
    public static ActivityVideoType convert(String value){
    	if ( "SPORT".equals(value) ) {
    		return ActivityVideoType.SPORT;
    	} else if ("LITERATURE".equals(value)) {
    		return ActivityVideoType.LITERATURE;
    	} else if ("EXHIBITION".equals(value)) {
    		return ActivityVideoType.EXHIBITION;
    	}/* else if ("OTHER".equals(value)) {
    		return ActivityTypeUtil.OTHER;
    	} else if ("RECRUITMENT".equals(value)) {
    		return ActivityTypeUtil.RECRUITMENT;
    	} */
    	return ActivityVideoType.EXHIBITION;
    }
    
    public static String convert(int value){
    	if ( 0==value ) {
    		return ActivityVideoType.SPORT.getName();
    	} else if (1==value ) {
    		return ActivityVideoType.LITERATURE.getName();
    	} else if (2==value ) {
    		return ActivityVideoType.EXHIBITION.getName();
    	}/* else if (3==value ) {
    		return ActivityTypeUtil.OTHER.getName();
    	} else if (4==value ) {
    		return ActivityTypeUtil.RECRUITMENT.getName();
    	} */
    	return ActivityVideoType.EXHIBITION.getName();
    }
    public static List<ActivityVideoType> list(){
    	List<ActivityVideoType> list = new ArrayList<ActivityVideoType>();
    	list.add(ActivityVideoType.SPORT);
      	list.add(ActivityVideoType.LITERATURE);
      	list.add(ActivityVideoType.EXHIBITION);
      /*	list.add(ActivityTypeUtil.OTHER);
      	list.add(ActivityTypeUtil.RECRUITMENT);*/
    	return list;
    }
}
