package com.bcxin.risk.report.domain;

import com.bcxin.risk.activity.Activity;
import com.bcxin.risk.base.domain.BaseBean;
import com.bcxin.risk.compose.draft.ComposeFrame;
import com.bcxin.risk.user.domain.User;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Data;

import javax.persistence.*;
import java.util.Date;

/**
 * 评估报告
 */
@Entity
@Table(name = "RISK_Report")
@Inheritance(strategy = InheritanceType.JOINED)
@JsonIgnoreProperties(value={"hibernateLazyInitializer","handler"})
@Data
public class Report extends BaseBean {

	private static final long serialVersionUID = 1L;

	/**
	 * 报告名称
	 */
	private String name;

	/**
	 * 报告状态
	 */
	private String reportStatus;

	/**
	 * 报告小状态
	 */
	private String reportSubStatus;

	@ManyToOne(targetEntity = User.class, fetch = FetchType.EAGER, cascade = CascadeType.PERSIST)
	@JoinColumn(name = "user_id")
	private User user;

	@ManyToOne(targetEntity = Activity.class, fetch = FetchType.LAZY, cascade = CascadeType.PERSIST)
	@JoinColumn(name = "activity_id")
	private Activity activity;


	/**
	 * 模板
	 */
	@ManyToOne(targetEntity = ComposeFrame.class, fetch = FetchType.LAZY, cascade = CascadeType.PERSIST)
	@JoinColumn(name = "frame_id")
	private ComposeFrame frame;

	private String reportUrgent;// 加急服务 （字典）

	private String expressMode;// 发票+纸质报告是否需要类型 （字典）

	@Temporal(TemporalType.TIMESTAMP)
	private Date assignDate; //如果是自营机构的评估报告，需要分配任务，这是分配任务的时间

	/**
	 * 评估机构审核意见
	 */
	private String assessmentComment;

	/* ---------------- 撰写相关的属性 -------------------*/
	/**
	 * 专家审核标志（1代表已经审核，0为未开始）
	 */
	private String approvalFlag;

	/**
	 * 专家审核意见
	 */
	private String approvalComment;

	/**
	 * 是否已经签名（1代表已经是，0为不是,3是签名中，4是重新签署）
	 */
	private String signature;

	/**
	 * 电子签章流程id
	 */
	private String esignFlowId;
}
