package com.bcxin.risk.policy.enums;

public enum ReportCaseStatus {
	
	/** 报案申请*/
	APPLY {public String getValue(){return "0";} public String getName(){return "报案申请";}}, 
	
	/** 已申请理赔*/
	CLAIM {public String getValue(){return "1";} public String getName(){return "申请理赔";} }, 
	
	/** 审核中*/
	ACCEPT {public String getValue(){return "2";} public String getName(){return "审核中";} }, 
	
	/** 审核通过*/
	PASS {public String getValue(){return "3";} public String getName(){return "审核通过";} }, 
	
	/** 理赔未通过*/
	REJECT {public String getValue(){return "4";} public String getName(){return "理赔未通过";} }, 
	
	/** 理赔未通过*/
	CLOSE {public String getValue(){return "5";} public String getName(){return "结案";} }, 
	
	/** 未知*/
	UNKNOW {public String getValue(){return "9";} public String getName(){return "未知";} }; 
	
    public abstract String getValue();
    
    public abstract String getName();
    
    public static ReportCaseStatus convert(String value){
    	if ( "APPLY".equals(value) ) {
    		return ReportCaseStatus.APPLY;
    	} else if ("CLAIM".equals(value)) {
    		return ReportCaseStatus.CLAIM;
    	} else if ("ACCEPT".equals(value)) {
    		return ReportCaseStatus.ACCEPT;
    	} else if ("PASS".equals(value)) {
    		return ReportCaseStatus.PASS;
    	} else if ("REJECT".equals(value)) {
    		return ReportCaseStatus.REJECT;
    	} else if ("CLOSE".equals(value)) {
    		return ReportCaseStatus.CLOSE;
    	} else if ("UNKNOW".equals(value)) {
    		return ReportCaseStatus.UNKNOW;
    	}
    	return ReportCaseStatus.CLAIM;
    }
}
