package com.bcxin.risk.policy.enums;


public enum Policy_ActivityScale {

	
	CPIC_BELOW {public String getValue(){return "1";} public String getName(){return "5000人以下";}}, 
	
	CPIC_MIDDLE {public String getValue(){return "2";} public String getName(){return "5000人-30000人";} }, 
	
	CPIC_UP {public String getValue(){return "3";} public String getName(){return "30000人以上";} }, 
	
	
	HT_BELOW {public String getValue(){return "11";} public String getName(){return "5000人以下（含5000人）";}},
	
	HT_MIDDLE {public String getValue(){return "12";} public String getName(){return "5000人-10000人（含10000人）";} },
	
	HT_SE_MIDDLE {public String getValue(){return "13";} public String getName(){return "10000人-50000人（含50000人）";} },
	
	HT_UP {public String getValue(){return "14";} public String getName(){return "50000人以上";} };
	
	
    public abstract String getValue();
    
    public abstract String getName();
    
    public static Policy_ActivityScale calc(String number,InsuranceCompany company){
    	int num = Integer.parseInt(number);
    	if ( InsuranceCompany.CPIC_PROPERTY.equals(company) ) {
    		if ( num < 5000 ) {
        		return CPIC_BELOW;
        	} else if ( 5000 <= num && num <= 30000 ) {
        		return CPIC_MIDDLE;
        	} else if( num > 30000 ) {
        		return CPIC_UP;
        	}
    	} else if ( InsuranceCompany.HT.equals(company) ) {
    		if ( num <= 5000 ) {
        		return HT_BELOW;
        	} else if ( 5000 <= num && num <= 10000 ) {
        		return HT_MIDDLE;
        	} else if ( 10000 < num && num <= 50000 ) {
        		return HT_SE_MIDDLE;
        	} else if( num > 50000 ) {
        		return HT_UP;
        	}
    	}
    	
    	return null;
    }
    
}
