package com.bcxin.risk.policy.enums;

import java.util.ArrayList;
import java.util.List;

public enum ClauseStatus {

	/** 具体条款*/
	SPECIFIC_CONDITIONS {public String getValue(){return "0";} public String getName(){return "具体条款";}}, 
	
	/** 除外责任*/
	EXCLUSIONS {public String getValue(){return "1";} public String getName(){return "除外责任";} }, 
	
	/** 赔付比例*/
	COMPENSATION_RATIO {public String getValue(){return "2";} public String getName(){return "赔付比例";} }; 
	
	
    public abstract String getValue();
    
    public abstract String getName();
    
    public static List<ClauseStatus> list(){
    	List<ClauseStatus> list = new ArrayList<ClauseStatus>();
    	list.add(COMPENSATION_RATIO);
    	list.add(EXCLUSIONS);
    	list.add(SPECIFIC_CONDITIONS);
    	return list;
    }
    
    public static ClauseStatus get(String value){
    	if("0".equals(value)){
    		return SPECIFIC_CONDITIONS;
    	}else if("1".equals(value)){
    		return EXCLUSIONS;
    	}else if("2".equals(value)){
    	return COMPENSATION_RATIO;
    	}else{
    		return null;
    	}
    }
}
