package com.bcxin.risk.policy.dto.data;

import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import com.bcxin.risk.policy.enums.PolicyStatus;
import com.bcxin.risk.policy.enums.PolicyType;
import com.bcxin.risk.policy.enums.SettlementStatus;
import lombok.Data;

import java.util.Map;

@Data
public class PolicyDto {

	private String oid;

	private String inceptionDate;

	private String plannedEndDate;

	private String htPlannedEndDate;

	private String signedDate;

	private String policySerialNumber;

	private String externalReference;
	
	private String createOn;
	
	private String reportName;
	
	private String productName;

	private String policyStatus; 
	
	private String policyStatusCN;

	private String policyTypeCN;

	private String settlementStatusCN;

	private String amount;

	private Page page;

	private String policyType;

	private String updateOn;

	private String settlementStatus;

	public PolicyDto(){}
	
	public PolicyDto(Map<String,Object> map){
		this.createOn = safeTransfor(map.get("createOn"));
		this.inceptionDate = safeTransfor(map.get("inceptionDate"));
		this.plannedEndDate = safeTransfor(map.get("plannedEndDate"));
		this.htPlannedEndDate = safeTransfor(map.get("htPlannedEndDate"));
		this.signedDate = safeTransfor(map.get("signedDate"));
		this.oid = safeTransfor(map.get("oid"));
		this.externalReference = safeTransfor(map.get("externalReference"));
		this.reportName = safeTransfor(map.get("reportName"));
		this.updateOn = safeTransfor(map.get("updateOn"));
		if ( StringUtil.isNotEmpty(this.policyStatus) ) {
			if ( this.reportName.length() > 20 ) {
				this.reportName = this.reportName.substring(0,20)+"..";
			}
		}
		this.productName = safeTransfor(map.get("productName"));
		this.policyStatus = safeTransfor(map.get("policyStatus"));
		this.policyType = safeTransfor(map.get("policyType"));
		this.amount = safeTransfor(map.get("amount"));
		this.policySerialNumber = safeTransfor(map.get("policySerialNumber"));
		this.settlementStatus = safeTransfor(map.get("settlementStatus"));
		if ( StringUtil.isNotEmpty(this.policyType) ) {
			PolicyType type = PolicyType.convert(this.policyType);
			if ( type != null) {
				this.setPolicyTypeCN(type.getDescription());
			}
		}
		if ( StringUtil.isNotEmpty(this.settlementStatus) ) {
			SettlementStatus status= SettlementStatus.convert(this.policyStatus);
			if ( status != null) {
				this.setSettlementStatusCN(status.getDescription());
			}
		}
		if ( StringUtil.isNotEmpty(this.policyStatus) ) {
			PolicyStatus policyStatus= PolicyStatus.convert(this.policyStatus);
			if ( policyStatus != null) {
				this.setPolicyStatusCN(policyStatus.getDescription());
			}
		}
	}
	
	
	/**
     * 
     * <b>Function 将Object安全转换为String</b> 
     * 
     * @param obj
     * @return
     * @author LuoPeng
     * @date 2016年12月22日 下午5:17:02
     * @注意事项 </b>
     * <b>
     */
    private String safeTransfor(Object obj){
		if ( obj == null ) {
			return "";
		}
		return obj.toString();
	}


}
