package com.bcxin.risk.policy.domain;

import java.math.BigDecimal;

import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Proxy;

import com.bcxin.risk.base.domain.BaseBean;
import com.bcxin.risk.policy.enums.AgeUnit;
import com.bcxin.risk.policy.enums.BenefitPeriodType;
import com.fasterxml.jackson.annotation.JsonBackReference;

/**
 * 保费配置
 * @author luopeng
 *
 */
@Entity
@Table(name = "RISK_RateSpec")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class RateSpec extends BaseBean {

	private static final long serialVersionUID = 1L;

	private Integer minPeriod;//最小期间
	private Integer maxPeriod;//最大期间
	
	@Enumerated(EnumType.STRING)
	private BenefitPeriodType periodType;//期间类型
	private String periodDescript;//期间描述
	private Integer minAge;//最小年龄
	private Integer maxAge;//最大年龄
	
	@Enumerated(EnumType.STRING)
	private AgeUnit ageUnit;//年龄类型
	private String ageDescript;//年龄期间描述
	private BigDecimal premium;//对应保费

	@ManyToOne(targetEntity = PlanSpec.class, fetch = FetchType.EAGER)
	@JoinColumn(name = "plan_id")
	@JsonBackReference
	private PlanSpec plan;//对应方案
	

}
