package com.bcxin.risk.policy.domain;

import java.util.Set;

import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;

import com.bcxin.risk.base.domain.BaseBean;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Proxy;

import com.fasterxml.jackson.annotation.JsonBackReference;

/**
 * 方案，对应产品
 * @author luopeng
 *
 */
@Entity
@Table(name = "RISK_PlanSpec")
@Inheritance(strategy = InheritanceType.JOINED)
@Proxy(proxyClass = PlanSpec.class)
@Data
@DynamicInsert(true)
@DynamicUpdate(true)

public class PlanSpec extends BaseBean  {

	private static final long serialVersionUID = 1L;

	private String name;
	private String externalReference;//方案编码
	private String feature;//方案描述
	private String suggest;//方案购买建议
	
	@ManyToOne(targetEntity = InsuranceProduct.class)
	@JoinColumn(name = "product_id")
	@JsonBackReference
	private InsuranceProduct product;//产品
	
	@OneToMany(targetEntity = AmountSpec.class, cascade = CascadeType.ALL, mappedBy = "plan", fetch = FetchType.EAGER)
	private Set<AmountSpec> amountSpec;//保障责任集合
	
	@OneToMany(targetEntity = RateSpec.class, cascade = CascadeType.ALL, mappedBy = "plan", fetch = FetchType.EAGER)
	private Set<RateSpec> rateSpec;//保费配置集合

}
