package com.bcxin.risk.policy.domain;

import java.math.BigDecimal;

import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import com.bcxin.risk.base.domain.BaseBean;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Proxy;

import com.fasterxml.jackson.annotation.JsonBackReference;

/**
 * 保额配置，对应具体方案
 * @author luopeng
 *
 */
@Entity
@Table(name = "RISK_amountSpec")
@Inheritance(strategy = InheritanceType.JOINED)
@Proxy(proxyClass = AmountSpec.class)
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class AmountSpec extends BaseBean {

	private static final long serialVersionUID = 1L;

	@ManyToOne(targetEntity = DutySpec.class, cascade = {CascadeType.PERSIST, CascadeType.REFRESH, CascadeType.MERGE}, fetch = FetchType.EAGER)
	@JoinColumn(name = "duty_id")
	private DutySpec dutySpec;//具体责任
	
	private BigDecimal amount;//保额
	
	@ManyToOne(targetEntity = PlanSpec.class)
	@JoinColumn(name = "plan_id")
	@JsonBackReference
	private PlanSpec plan;//方案
	
	private String description;//描述

}
