package com.bcxin.risk.org.domain;

import com.bcxin.risk.base.domain.BaseBean;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;

/**
 * 服务机构（权限控制）
 * @author luopeng
 *
 */
@Entity
@Table(name = "RISK_ServiceOrg_auth")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class ServiceOrgAuth extends BaseBean {

	private static final long serialVersionUID = 1L;

	/**
	 * 权限名（字典：SERVICEORGAUTH）
	 */
	private String authType;

	/**
	 * 权限值
	 */
	private String authValue;

	/**
	 * 所属机构
	 */
	private Long org_id;


}
