package com.bcxin.risk.org.domain;

import com.bcxin.risk.base.domain.BaseBean;
import com.bcxin.risk.user.domain.User;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;

/**
 * 待审核的机构，机构注册功能数据临时存放
 * @author luopeng
 *
 */
@Entity
@Table(name = "RISK_PendOrg")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class PendOrg extends BaseBean {

	private static final long serialVersionUID = 1L;
	
	private String userName;//登陆用户名，与user对应

	private String serviceOrgType;//类型，值参考OrgTypeUtil
	
	private String name;
	
	private String logo;
	
	private String contactName;
	
	private String contactPhone;
	
	private String contactAddress;
	
	private String introduce; //介绍
	
	private String experts; //专家团队

	private String business_license_num;//营业执照号码
	
	private String business_license;//营业执照副本照片
	
	private String comment;//审批不通过原因
	
	private String approvalStatus ;//审核状态，（字典）

	@OneToOne(targetEntity = User.class, fetch = FetchType.EAGER)
	@JoinColumn(name = "user_id")
	private User user; //用户

	private Long area_id;  // 区域ID

	private Long city_id;  // 城市ID

	private Long province_id;  // 省份ID

}
