package com.bcxin.risk.org.domain;

import com.bcxin.risk.base.domain.BaseBean;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;

/**
 * 机构的基类
 * @author luopeng
 *
 */
@Entity
@Table(name = "RISK_Org")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class Org extends BaseBean{

	private static final long serialVersionUID = 1L;

	private String code; //代码

	private String name; //名称

	private String address;

	private String orgType;//机构类型（字典）

	private String govOrgFlag; // 政府单位标志

	private Long area_id;  // 区域ID

	private Long city_id;  // 城市ID

	private Long province_id;  // 省份ID

	private Long parent_id;  // 上级机构ID

	private String isSync ; // 业务支撑同步标志 0:未同步，1:同步

	private String ywzcId ; // 业务支撑ID

	private String esignId;//机构e签宝Id，电子签章

	private String active ; //是否有效 0:无效，1:有效

	/**
	 * saas的企業id
	 */
	private String saasComId;
}
