package com.bcxin.risk.order;

import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 线下交易
 * @author luopeng
 *
 */
@Entity
@Table(name = "RISK_TransactionOffline")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class TransactionOffline extends Transaction {

	@Temporal(TemporalType.TIMESTAMP)
	private Date accountTime;//到账时间

	private BigDecimal confirmAmount;//确认金额

	private String payOrg;//付款单位

	private String payAccount;//付款账户

	private String payVoucher;//支付凭证

}
