package com.bcxin.risk.order;

import com.bcxin.risk.base.domain.BaseBean;
import com.bcxin.risk.user.domain.User;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;

/**
 * 专家订单
 */
@Entity
@Table(name = "RISK_ExpertOrderForm")
@Inheritance(strategy = InheritanceType.JOINED)
@JsonIgnoreProperties(value={"hibernateLazyInitializer","handler"})
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class ExpertOrderForm extends BaseBean {

	private static final long serialVersionUID = 1L;
	
	@ManyToOne(targetEntity = User.class, fetch = FetchType.EAGER, cascade = CascadeType.PERSIST)
	@JoinColumn(name = "user_id")
	private User user;

	@OneToOne(targetEntity = OrderForm.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "orderForm_id")
	private OrderForm orderForm;//订单信息

	private String orderType;//订单类型 1：勘查 2：撰写

	private String step;//阶段

	private String isSync = "0"; // 业务支撑同步标志 0:未同步，1:同步

	// 专家订单状态，对应数据字典 expertOrderStatus
	// 待处理，已接受，已拒绝，待结算、已取消，已结算
	//private String orderStatus;

	// 薪酬
	//private String payment;

}
