package com.bcxin.risk.news.domain;

import com.bcxin.risk.base.domain.BaseBean;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Type;

import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;
import java.util.Date;

/**
 * 新闻资讯
 */
@Entity
@Table(name = "RISK_News")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class News extends BaseBean {
	
	private static final long serialVersionUID = 1L;

	/**
	 * 标题
	 */
	private String title;

	/**
	 * 内容
	 */
	@Type(type = "text")
	private String content;
	
	/**
	 * 新闻来源 字典
	 */
	private String category;

	/**
	 * 所属省份Id
	 */
	private String provinceId;

	/**
	 * 类别 字典
	 */
	private String newsType;

	/**
	 * 优先级  2:重要； 1：最新； 0：普通(字典)
	 */
	private String priority;

	/**
	 * 发布时间
	 */
	private Date publishDate;

	/**
	 * 附件名称
	 */
	private String attachmentName;

	/**
	 * 附件 url
	 */
	private String attachment;

	/**
	 * 新闻唯一标识
	 */
	private String uuid;

}
