package com.bcxin.risk.log.dto.search;

import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.enums.OperateLogTypeEnum;
import com.bcxin.risk.hibernateplus.entity.page.Page;
import lombok.Data;

import java.io.Serializable;
import java.util.Map;
import java.util.Objects;

/**
 * @author hzp
 * 操作日志结果对象
 */
@Data
public class OperateLogDto implements Serializable {

    private String oid;

    private String userId;

    private String userName;

    private String operateType;

    private String operateTypeName;

    private String bizId;

    private String sourceId;

    private String operateTime;

    private String content;

    private String ip;

    private String activityId;

    private String activityName;

    private String success;

    private Page page;

    public OperateLogDto(Map<String,Object> map){
        this.oid=safeTransfer(map.get("oid"));
        this.userId=safeTransfer(map.get("userId"));
//        this.userName=safeTransfer(map.get("realName"));
        if(StringUtil.isEmpty(this.userName)){
            this.userName=safeTransfer(map.get("userName"));
        }
        this.operateType=safeTransfer(map.get("operateType"));
        if(StringUtil.isNotEmpty(operateType)){
            this.operateTypeName=OperateLogTypeEnum.getAlias(operateType);
        }
        this.operateTime=safeTransfer(map.get("operateTime"));
        this.bizId=safeTransfer(map.get("bizId"));
        this.sourceId=safeTransfer(map.get("sourceId"));
        this.content=safeTransfer(map.get("content"));
        this.ip=safeTransfer(map.get("ip"));
        this.activityId=safeTransfer(map.get("activityId"));
        this.activityName=safeTransfer(map.get("activityName"));
        String success=safeTransfer(map.get("success"));
        if(Objects.equals(success,"1")){
            this.success="成功";
        }else if(Objects.equals(success,"0")){
            this.success="失败";
        }
    }

    private static String safeTransfer(Object obj){
        if ( obj == null ) {
            return "";
        }
        return obj.toString();
    }
}
