package com.bcxin.risk.enums;

/**
 * 单据分类
 */
public enum BillCategoryEnum {

    ACTIVITY("ACTIVITY","活动类");

    private String key;
    private String alias;

    BillCategoryEnum(String key, String alias){
        this.key=key;
        this.alias=alias;
    }

    public String getKey(){
        return this.key;
    }

    public String getAlias(){
        return this.alias;
    }

    public static String getAlias(String key){
        for(BillCategoryEnum e : BillCategoryEnum.values()){
            if(e.getKey().equals(key)){
                return e.getAlias();
            }
        }
        return "";
    }
}
