package com.bcxin.risk.dynamic.dto;

import com.bcxin.risk.base.domain.util.StringUtil;
import com.bcxin.risk.user.domain.User;
import lombok.Data;

import java.io.Serializable;

/**
 * 活动动态看板
 */
@Data
public class DynamicActPanel implements Serializable {

    /**
     * 操作人
     */
    private String operateName;

    /**
     * 登录名
     */
    private String userName;
    /**
     * 操作人id
     */
    private String operateId;
    /**
     * 活动id
     */
    private String activityId;
    /**
     * 活动名称
     */
    private String activityName;

    public DynamicActPanel(){

    }

    public DynamicActPanel(User user, String activityId, String activityName){
        if(user!=null){
//            this.operateName=user.getRealName();
            if(StringUtil.isEmpty(this.operateName)){
                this.operateName=user.getUserName();
            }
            this.userName=user.getUserName();
            this.operateId=user.getOid()+"";
        }
        this.activityId=activityId;
        this.activityName=activityName;
    }
}
