package com.bcxin.risk.dynamic;

import com.bcxin.risk.base.domain.BaseBean;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.*;

/**
 * @author 动态看板数据
 */
@Entity
@Table(name = "risk_dynamic_panel")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class DynamicPanel extends BaseBean {

    @ManyToOne(targetEntity = DynamicPanelTemplate.class, fetch = FetchType.EAGER, cascade = CascadeType.PERSIST)
    @JoinColumn(name = "templateId")
    private DynamicPanelTemplate dynamicPanelTemplate;

    /**
     * 动态类型
     */
    private String dynamicType;

    /**
     * 动态权限
     */
    private String dynamicPermission;

    /**
     * 活动id
     */
    private Long activityId;

    /**
     * 活动名称
     */
    private String activityName;

    /**
     * 模板数据
     */
    private String templateData;

    /**
     * 操作人id
     */
    private Long operateId;

    /**
     * 操作人id
     */
    private String operateName;

    /**
     * 操作人用户类型
     */
    private String operateType;

    /**
     * 风评机构id
     */
    private Long orgId;

    /**
     * 承办方机构id
     */
    private Long contractOrgId;

    /**
     * 是否显示
     */
    private String isShow="1";

}
