package com.bcxin.risk.compose.source;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;

/**
 * 会展场馆
 * @author 070
 */
@Entity
@Table(name = "venue_Stadium")
@Inheritance(strategy = InheritanceType.JOINED)
@JsonIgnoreProperties(value={"hibernateLazyInitializer","handler"})
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class VenueStadium extends VenueBase {


    /** 经度 */
    private String jingdu;

    /** 纬度 */
    private String weidu;

    /** 建立时间 */
    private String buildDate;

    /** 竣工时间 */
    private String completeDate;

    /** 营业执照 */
    private String zhizhao;

    /** 组织机构代码证 */
    private String daimazheng;

    /** 税务登记证 */
    private String shuiwuzheng;

    /** 其他资质文件 */
    private String other;

    /** 经营范围 */
    private String jingying;

    /** 总用地面积 */
    private String mianji;

    /** 建筑占地面积 */
    private String jianzhu;

    /** 建筑面积 */
    private String jianzhuarea;

    /** 场地面积 */
    private String changdimianji;

    /** 场地限高 */
    private String changdixiangao;

    /** 场地平面图 */
    private String photo;

    /** 座位总数 */
    private String zuowei;

    /** 固定座位/使用坐席 */
    private String gudingzuowei;

    /** 活动座位/使用坐席 */
    private String huodongzuowei;

    /** 可容纳人数 */
    private String people;

    /** 出入口数量 */
    private String churukoushuliang;

    /** 出入口宽度 */
    private String churukoukuandu;

    /** 紧急疏散口数量 */
    private String jinjishusankoushuliang;

    /** 紧急疏散口宽度 */
    private String jinjishusankoukuandu;

    /** 场馆最大负荷 */
    private String changguanzuidafuhe;

    /** 电源分布 */
    private String dianyuan;

    /** 配电柜/配电箱数量 */
    private String peidianguishuliang;

    /** 供电频率 */
    private String gongdian;

    /** 供电电压 */
    private String dianya;

    /** 消防配备情况 */
    private String xiaofang;

    /** 消防水炮数量 */
    private String xiaofangshuipaoshuliang;

    /** 喷淋系统数量 */
    private String penlinxitongshuliang;

    /** 烟感器数量 */
    private String yanganqishuliang;

    /** 场地消防验收意见书 */
    private String yijianshu;

    /** 固定厕所数量 */
    private String gudingcesuoshuliang;

    /** 配套设施位置图 */
    private String weizhitu;
    /** 场馆介绍 */
    private String introduction;

    /** 区域位置 */
    private String adress;

    /** 建筑结构 */
    private String jiegou;

    /** 出入口方位 */
    private String churukoufangwei;

    /** 应急疏散指示墙体标识 */
    private String yingjishusanzhishiqiangtibiaoshi;

    /** 应急疏散指示地标识 */
    private String yingjishusanzhishidibiaoshi;

    /** 经营设施及分布情况 */
    private String shes;

    /** 应急供电设备 */
    private String yingjigongdianshebei;

    /** 喷淋系统分布区域 */
    private String penlinxitongfenbuquyu;

    /** 烟感器分布区域 */
    private String yanganqifenbuquyu;

    /** 通讯信号器 */
    private String tongxunxinhaoqi;

    /** 楼梯 */
    private String louti;

    /** 电梯 */
    private String dianti;

    /** 自动扶梯 */
    private String zidong;

    /** 疏散通道 */
    private String shusan;

    /** 无障碍通道 */
    private String wuzhangai;

    /** 监控系统可用状态 */
    private String jiankongxitongkeyongzhuangtai;

    /** 监控指挥中心可用状态 */
    private String jiankongzhihuizhongxinkeyongzhuangtai;

    /** 场内监控可用状态 */
    private String changneijiankongkeyongzhuangtai;

    /** 场外监控可用状态 */
    private String changwaijiankongkeyongzhuangtai;

    /** 应急广播 */
    private String yingjiguangbo;

    /** 应急照明 */
    private String yingjizhaoming;

    /** 通风设施 */
    private String tongfengsheshi;

    /** 停车位 */
    private String tingchewei;

    /** 周边建筑及商业密度 */
    private String zhoub;

    /** 加油站/危险品仓库 */
    private String jiayouzhan;

    /** 避难场所 */
    private String binanchangsuo;

    /** 拥堵地段 */
    private String yongji;

    /** 公共交通 */
    private String gonggongjiaotong;

    /** 公交车站 */
    private String busStation;

    /** 出租车站 */
    private String taxi;
}