package com.bcxin.risk.common.vo;

import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import javax.servlet.http.HttpServletRequest;

@Data
public class DwzPage {

	private int pageNum = 1; // 当前页数
	private int numPerPage = 20; // 每页个数
	private int totalCount = 0; // 总数
	private int backPage=1;  //上一页
	private int  nextPage=1;//下一页
	private int lastPage=1;// 后一页
	private String orderField; // 排序方式
	private String orderDirection; // 用来切换 图标
	private String html; //页面显示table
	
	public String getHtml() {
		return html;
	}

	public void setHtml(String html) {
		this.html = html;
	}


	/**
	 * 构造方法
	 */
	public DwzPage(HttpServletRequest request){
		// 设置页码参数（传递repage参数，来记住页码）
		String no = request.getParameter("pageNum");
		if (StringUtils.isNumeric(no)){
			this.setPageNum(Integer.parseInt(no));
		}
		// 设置页面大小参数（传递repage参数，来记住页码大小）
		String size = request.getParameter("numPerPage");
		if (StringUtils.isNumeric(size)){
			this.setNumPerPage(Integer.parseInt(size));
		}
	}
	public DwzPage() {
	}

}
