package com.bcxin.risk.common.domain;

import com.bcxin.risk.base.domain.BaseBean;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Entity;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.Table;

/**
 * 人员通知表
 * <b>管理后台配置发送信息</b>
 * @author 张建华
 * @date 2018/9/13
 */
@Entity
@Table(name = "config_notifyperson")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert(true)
@DynamicUpdate(true)
public class NotifyPerson extends BaseBean {


    /**
     * 通知类型
     */
    private String notifyPersonType;

    /**
     * 通知电话
     */
    private String phone;

    /**
     * 通知邮箱
     */
    private String email;


}
