package com.bcxin.risk.activity.dto.data;

import com.bcxin.risk.common.domain.SyncTask;
import lombok.Data;

@Data
public class SBDataDTO {

	/**
	 * 同步类型
	 */
	private String syncTaskType;

	private String userName;

	private String oldUserName;

	private String password;

	private String phone;

	private String oldPhone;

	private String email;

	private String active;

	private String userType;

	private String channel;

	private String reportUrl;

	private String activityNo;

	private String step;

	private String materialUrl;

	private String materialType;

	/**
	 * 通用内容
	 */
	private String content;

	/**
	 * 温馨提示
	 */
	private  String tips;

	/**
	 * 便民服务
	 */
	private String assessment;

	/**
	 * 用于用户注册
	 */
	private String userDTO;

	/**
	 * 用于用户注册，政府单位
	 */
	private String orgDataDTO;

	/**
	 * 用于用户注册，公安机关
	 */
	private String policeOrgDataDTO;

	/**
	 * 用户参数
	 */
	private String userParam;

	/**
	 * 活动信息参数
	 */
	private String activityParam;

	/**
	 * 审批日志参数
	 */
	private String approveLogParam;

	/**
	 * 报告参数
	 */
	private String reportParam;

	/**
	 * 主体材料参数
	 */
	private String materialModuleParam;
	/**
	 * 材料信息参数
	 */
	private String materialParam;

	/**
	 * 安保任务相关参数
	 */
	private String securityParam;

	/**
	 * 同步文件相关
	 */
	private String fileUrl;

	/**
	 * 主站的文件目录 /data/pss/material/china/2017-08-23/dh/
	 */
	private String dir;
	/**
	 *  主站文件名 2017082392912.txt
	 */
	private String fileName;
	/**
	 * 主站的材料上传基本路径  /data/pss/material/
	 */
	private String materialBasePath;
	/**
	 *  主站的环境  china
	 */
	private String envi;
	/**
	 * 用户记录每次同步的状态
	 */
	private SyncTask task;

	/**
	 * 系统升级提示
	 */
	private String sysTips;

	/**
	 * 用于用户信息修改（公司修改信息）
	 */
	private String user;

	/**
	 * 站点名称
	 */
	private String platformName;


	/**
	 * 机构
	 */
	private String org;

	/**
	 * changeLog
	 */
	private String oldMap;
	private String newMap;

	/**
	 * 发送消息
	 */
	private String sendTitle;
	private String sendContent;

	/**
	 * 转交省、市、区
	 */
	private String transferProvince;
	private String transferCity;
	private String transferArea;

	/**
	 * 审批状态
	 */
	private String approveStatus;

	/**
	 * 审批单位
	 */
	private String approveOrg;
}
