package com.bcxin.risk.activity.dto.data;

import lombok.Data;

import java.util.Map;

/**
 * @param
 * @return
 * @auther Administrator
 * @date 2017/11/20 0020
 * @注意事项 </b>
 */
@Data
public class BLBCommunicationDto {

    /**
     * 活动ID
     */
    private String activity_id;

    /**
     * 活动名称
     */
    private String name;
    /**
     *承办（执行）单位名称
     */
    private String user_name;
    /**
     * 活动类型
     1	    TY-体育比赛活动
     2		WY-演唱会、音乐会等文艺演出活动
     3		ZL-展览会、展销会、交流会等活动

     7		QT-其他类活动
     4		游园、灯会、庙会、花会、焰火晚会、美食节等活动
     5		招聘会、推介会、现场开奖的彩票销售等活动
     6		公益慈善活动
     */
    private String activityType;
    /**
     * 活动地址，xxxx,xxxx
     */
    private String address;

    /**
     * 活动地点（室内和室外） 字典
     *
     1      INDOOR-全封闭（室内）----室内场馆
     2      OPEN-半封闭（室内露天）---露天场馆
     3      OUTDOOR-开放式（室外）---户外场馆
     4      室内+室外
     5      其他
     */
    private String addressType;

    /**
     * 预计当日人数
     */
    private String peakNum;

    /**
     * 开始时间
     */
    private String startDate;

    /**
     * 结束时间
     */
    private String endDate;


    /**
     * 发票信息
     */
    //-----------------------------------------寄送信息----------------
    private String reportExpressMode;//（字典） 不寄送0   寄送报告 	1
    private String invoiceExpressMode;//（字典）不寄送 0，普通发票 1，增值税发票 2

    private String invoiceTitle;// 发票的抬头

    private String expressSelf; //发票和报告的收件人是否为同一人；1代表是，0代表不是


    //-----------------------------------------纸质报告----------------
    private String recipientName;//收件人姓名
    private String recipientPhone;//收件人电话
    private String recipientAddress;//收件人地址


    //-----------------------------------------发票-------------------
    //普通发票
    private String ticketName;//收票人姓名
    private String ticketPhone;//收票人电话
    private String ticketAddress;//收票人地址
    private String taxpayerNumberInvoice;//纳税人识别号
    private String companyNameInvoice;//单位名称

    //增值税发票
    private String registerAddressInvoice;//公司注册地址
    private String contactPhoneInvoice;//公司电话
    private String bankInvoice;//开户银行
    private String bankAccountInvoice; //银行账号

    private String tax_cert;//税务登记证
    private String business_license;// 营业执照



    public BLBCommunicationDto(Map<String,Object> map){
        this.activity_id = safeTransfor(map.get("activity_id"));
        this.name = safeTransfor(map.get("name"));
    }

    public BLBCommunicationDto(){
    }


    private static String safeTransfor(Object obj){
        if ( obj == null ) {
            return "";
        }
        return obj.toString();
    }


}
