package com.bcxin.risk.activity.dto.data;

import com.bcxin.risk.hibernateplus.entity.page.Page;
import lombok.Data;

import java.util.Map;

@Data
public class ActivityDataDTO {

	private String oid;
	
	private String name;
	
	private String userId;
	
	private String startDate;

	private String endDate ; 

	private String province;

	private String city;

	private String area;

	private String addressCity;

	private String address; 

	private String number;

	/**
	 * 活动天数
	 */
	private String days;
	
	private String sponsor;
	
	private String approvalStatus;
	
	private String createOn;
	
	private String orderNo;
	
	private String activityType;
	
	private String activitySource;

	private String activityStatus;

	private String activityStatusLabel;
	
	private String amount;
	
	private String reportAmount;
	
	private String updateOn;

	private String gov;

	private String chooseAssess ;

	private String assessment ;

	private String[] serviceOrgIds;

	private Page page;

	public ActivityDataDTO(){}

	public ActivityDataDTO(Map<String,Object> map){
		this.oid = safeTransfor(map.get("oid"));
		this.name = safeTransfor(map.get("name"));
		if ( this.name.length() > 20 ) {
			this.name = this.name.substring(0,20)+"..";
		}
		this.orderNo = safeTransfor(map.get("orderNo"));
		if (safeTransfor(map.get("createOn")).length()>2) {
			this.createOn = safeTransfor(map.get("createOn")).substring(0,safeTransfor(map.get("createOn")).length()-2);
		}
		if (safeTransfor(map.get("updateOn")).length()>2) {
			this.updateOn = safeTransfor(map.get("updateOn")).substring(0,safeTransfor(map.get("updateOn")).length()-2);
		}else{
			this.updateOn=safeTransfor(map.get("updateOn"));
		}
		this.activityType = safeTransfor(map.get("activityType"));
		this.activityStatus = safeTransfor(map.get("activityStatus"));
		this.amount = safeTransfor(map.get("amount"));
		this.reportAmount = safeTransfor(map.get("reportAmount"));
		this.userId = safeTransfor(map.get("userId"));
		this.activityStatusLabel = safeTransfor(map.get("activityStatusLabel"));
		this.gov = safeTransfor(map.get("gov"));
		this.chooseAssess = safeTransfor(map.get("chooseAssess"));
		this.assessment = safeTransfor(map.get("assessment"));
		this.province=safeTransfor(map.get("province"));
		this.city=safeTransfor(map.get("city"));
		this.area=safeTransfor(map.get("area"));
		this.addressCity=safeTransfor(map.get("addressCity"));
		this.address=safeTransfor(map.get("address"));
		this.startDate=safeTransfor(map.get("startDate"));
		this.endDate=safeTransfor(map.get("endDate"));
		this.sponsor=safeTransfor(map.get("sponsor"));
		this.activitySource=safeTransfor(map.get("activitySource"));
	}
	
	
	/**
     * 
     * <b>Function 将Object安全转换为String</b> 
     * 
     * @param obj
     * @return
     * @author LuoPeng
     * @date 2016年12月22日 下午5:17:02
     * @注意事项 </b>
     * <b>
     */
    private String safeTransfor(Object obj){
		if ( obj == null ) {
			return "";
		}
		return obj.toString();
	}

}
