package com.bcxin.risk.activity;

import com.bcxin.risk.user.domain.User;
import com.bcxin.risk.base.domain.BaseBean;
import lombok.Data;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Type;

import javax.persistence.*;

/**
 * 【活动】活动材料表
 * @author luopeng
 *
 */
@Entity
@Table(name = "RISK_ActivityMaterial")
@Inheritance(strategy = InheritanceType.JOINED)
@Data
@DynamicInsert
@DynamicUpdate
public class ActivityMaterial extends BaseBean {

	private static final long serialVersionUID = 1L;

	/**
	 * 活动
	 */
	@ManyToOne(targetEntity = Activity.class, fetch = FetchType.LAZY)
	@JoinColumn(name = "activity_id")
	private Activity activity;

	/**
	 * 材料类型（字典）
	 */
	private String activityMaterialType;

	/**
	 * 材料路径
	 */
	@Type(type="text")
	private String value;

	/**
	 * 是否提交公安
	 */
	private String commitStatus;

	@ManyToOne(targetEntity = User.class, fetch = FetchType.LAZY, cascade = CascadeType.PERSIST)
	@JoinColumn(name = "user_id")
	private User user;
}
